/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.scoreboard;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.mccore.scoreboard.Board;
import studio.magemonkey.codex.mccore.scoreboard.BoardManager;
import studio.magemonkey.codex.mccore.scoreboard.PlayerBoards;
import studio.magemonkey.codex.mccore.scoreboard.ScoreboardNodes;

public class ListCommand<P extends CodexPlugin<P>>
extends ISubCommand<P> {
    ListCommand(P plugin) {
        super(plugin, List.of("list"), ScoreboardNodes.LIST.getNode());
    }

    @Override
    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        StringBuilder message = new StringBuilder(String.valueOf(ChatColor.DARK_GREEN) + "Active Scoreboards: ");
        PlayerBoards boards = BoardManager.getPlayerBoards(sender.getName());
        for (Board board : boards.getBoards()) {
            message.append(ChatColor.GOLD).append(ChatColor.stripColor((String)board.getName())).append(ChatColor.GRAY).append(", ");
        }
        sender.sendMessage(message.toString());
    }

    @Override
    @NotNull
    public String usage() {
        return "";
    }

    @Override
    @NotNull
    public String description() {
        return "Displays a list of active scoreboards";
    }

    @Override
    public boolean playersOnly() {
        return true;
    }
}

