/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.scoreboard;

import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import studio.magemonkey.codex.mccore.scoreboard.BoardManager;

public abstract class Board {
    protected final String plugin;
    private final String title;
    private final Scoreboard scoreboard;
    private final Objective objective;
    private UUID uuid;

    public Board(String title, String plugin) {
        this.plugin = plugin;
        this.title = title;
        if (Bukkit.getScoreboardManager() == null) {
            throw new IllegalStateException("Scoreboard manager is null");
        }
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        this.objective = this.scoreboard.registerNewObjective(title, "dummy");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    public void setPlayer(Player player) {
        this.uuid = player.getUniqueId();
    }

    public String getName() {
        return this.title;
    }

    protected void set(String label, int score) {
        this.resetScores(score);
        this.objective.getScore(label).setScore(score);
    }

    private void resetScores(int score) {
        if (this.objective.getScoreboard() == null) {
            return;
        }
        this.objective.getScoreboard().getEntries().stream().filter(str -> this.objective.getScore(str).getScore() == score).forEach(arg_0 -> ((Scoreboard)this.objective.getScoreboard()).resetScores(arg_0));
    }

    public boolean showPlayer() {
        Player player = this.getPlayer();
        if (player == null || !player.isOnline()) {
            return false;
        }
        BoardManager.update(this.scoreboard);
        player.setScoreboard(this.scoreboard);
        return true;
    }

    protected Player getPlayer() {
        if (this.uuid == null) {
            return null;
        }
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @Deprecated
    public void setHealthLabel(String label) {
        BoardManager.setTextBelowNames(label);
    }

    public void clearDisplay() {
        Player player = this.getPlayer();
        if (player == null || !player.isOnline() || Bukkit.getScoreboardManager() == null) {
            return;
        }
        Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
        BoardManager.update(board);
        player.setScoreboard(board);
    }

    public int hashCode() {
        return this.title.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Board && this.title.equals(((Board)other).title);
    }

    @Generated
    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }
}

