/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.gui;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.mccore.config.Config;
import studio.magemonkey.codex.mccore.gui.MapData;
import studio.magemonkey.codex.mccore.gui.MapListener;
import studio.magemonkey.codex.mccore.gui.MapMenu;

public class MapMenuManager {
    private static HashMap<String, MapData> data = new HashMap();
    private static HashMap<Integer, MapData> idMap = new HashMap();
    private static Config config;

    public static MapData getData(String menuKey) {
        return data.get(menuKey);
    }

    public static void registerMenu(String key, MapMenu root) {
        if (data.size() == 0) {
            new MapListener(CodexEngine.get());
        }
        if (data.containsKey(key)) {
            Bukkit.getLogger().severe("Duplicate map menu key: " + key);
            return;
        }
        MapMenuManager.init();
        MapView view = null;
        int id = config.getConfig().getInt(key, -1);
        if (id >= 0 && (view = Bukkit.getMap((int)((short)id))) == null) {
            id = -1;
        }
        if (id == -1) {
            view = Bukkit.createMap((World)((World)Bukkit.getWorlds().get(0)));
        }
        if (view == null) {
            return;
        }
        config.getConfig().set(key, (Object)view.getId());
        config.saveConfig();
        MapData mapData = new MapData(root, view);
        data.put(key, mapData);
        idMap.put(view.getId(), mapData);
    }

    public static MapData getActiveMenuData(Player player) {
        short id;
        if (player == null || idMap.size() == 0) {
            return null;
        }
        ItemStack map = player.getItemInHand();
        if (map != null && map.getType() == Material.MAP && idMap.containsKey(id = map.getDurability())) {
            return idMap.get(id);
        }
        return null;
    }

    public static void sendBack(Player player) {
        MapData data = MapMenuManager.getActiveMenuData(player);
        if (data != null) {
            data.back(player);
        }
    }

    public static void sendNext(Player player, MapMenu menu) {
        MapData data = MapMenuManager.getActiveMenuData(player);
        if (data != null) {
            data.next(player, menu);
        }
    }

    private static void init() {
        if (config == null) {
            config = new Config(CodexEngine.get(), "maps");
        }
    }
}

