/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.bukkit.map.MapCanvas;
import studio.magemonkey.codex.mccore.gui.MapFont;

public class MapImage {
    private static final Color[] colors = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), MapImage.c(89, 125, 39), MapImage.c(109, 153, 48), MapImage.c(127, 178, 56), MapImage.c(67, 94, 29), MapImage.c(174, 164, 115), MapImage.c(213, 201, 140), MapImage.c(247, 233, 163), MapImage.c(130, 123, 86), MapImage.c(117, 117, 117), MapImage.c(144, 144, 144), MapImage.c(167, 167, 167), MapImage.c(88, 88, 88), MapImage.c(180, 0, 0), MapImage.c(220, 0, 0), MapImage.c(255, 0, 0), MapImage.c(135, 0, 0), MapImage.c(112, 112, 180), MapImage.c(138, 138, 220), MapImage.c(160, 160, 255), MapImage.c(84, 84, 135), MapImage.c(117, 117, 117), MapImage.c(144, 144, 144), MapImage.c(167, 167, 167), MapImage.c(88, 88, 88), MapImage.c(0, 87, 0), MapImage.c(0, 106, 0), MapImage.c(0, 124, 0), MapImage.c(0, 65, 0), MapImage.c(180, 180, 180), MapImage.c(220, 220, 220), MapImage.c(255, 255, 255), MapImage.c(135, 135, 135), MapImage.c(115, 118, 129), MapImage.c(141, 144, 158), MapImage.c(164, 168, 184), MapImage.c(86, 88, 97), MapImage.c(129, 74, 33), MapImage.c(157, 91, 40), MapImage.c(183, 106, 47), MapImage.c(96, 56, 24), MapImage.c(79, 79, 79), MapImage.c(96, 96, 96), MapImage.c(112, 112, 112), MapImage.c(59, 59, 59), MapImage.c(45, 45, 180), MapImage.c(55, 55, 220), MapImage.c(64, 64, 255), MapImage.c(33, 33, 135), MapImage.c(73, 58, 35), MapImage.c(89, 71, 43), MapImage.c(104, 83, 50), MapImage.c(55, 43, 26), MapImage.c(180, 177, 172), MapImage.c(220, 217, 211), MapImage.c(255, 252, 245), MapImage.c(135, 133, 129), MapImage.c(152, 89, 36), MapImage.c(186, 109, 44), MapImage.c(216, 127, 51), MapImage.c(114, 67, 27), MapImage.c(125, 53, 152), MapImage.c(153, 65, 186), MapImage.c(178, 76, 216), MapImage.c(94, 40, 114), MapImage.c(72, 108, 152), MapImage.c(88, 132, 186), MapImage.c(102, 153, 216), MapImage.c(54, 81, 114), MapImage.c(161, 161, 36), MapImage.c(197, 197, 44), MapImage.c(229, 229, 51), MapImage.c(121, 121, 27), MapImage.c(89, 144, 17), MapImage.c(109, 176, 21), MapImage.c(127, 204, 25), MapImage.c(67, 108, 13), MapImage.c(170, 89, 116), MapImage.c(208, 109, 142), MapImage.c(242, 127, 165), MapImage.c(128, 67, 87), MapImage.c(53, 53, 53), MapImage.c(65, 65, 65), MapImage.c(76, 76, 76), MapImage.c(40, 40, 40), MapImage.c(108, 108, 108), MapImage.c(132, 132, 132), MapImage.c(153, 153, 153), MapImage.c(81, 81, 81), MapImage.c(53, 89, 108), MapImage.c(65, 109, 132), MapImage.c(76, 127, 153), MapImage.c(40, 67, 81), MapImage.c(89, 44, 125), MapImage.c(109, 54, 153), MapImage.c(127, 63, 178), MapImage.c(67, 33, 94), MapImage.c(36, 53, 125), MapImage.c(44, 65, 153), MapImage.c(51, 76, 178), MapImage.c(27, 40, 94), MapImage.c(72, 53, 36), MapImage.c(88, 65, 44), MapImage.c(102, 76, 51), MapImage.c(54, 40, 27), MapImage.c(72, 89, 36), MapImage.c(88, 109, 44), MapImage.c(102, 127, 51), MapImage.c(54, 67, 27), MapImage.c(108, 36, 36), MapImage.c(132, 44, 44), MapImage.c(153, 51, 51), MapImage.c(81, 27, 27), MapImage.c(17, 17, 17), MapImage.c(21, 21, 21), MapImage.c(25, 25, 25), MapImage.c(13, 13, 13), MapImage.c(176, 168, 54), MapImage.c(215, 205, 66), MapImage.c(250, 238, 77), MapImage.c(132, 126, 40), MapImage.c(64, 154, 150), MapImage.c(79, 188, 183), MapImage.c(92, 219, 213), MapImage.c(48, 115, 112), MapImage.c(52, 90, 180), MapImage.c(63, 110, 220), MapImage.c(74, 128, 255), MapImage.c(39, 67, 135), MapImage.c(0, 153, 40), MapImage.c(0, 187, 50), MapImage.c(0, 217, 58), MapImage.c(0, 114, 30), MapImage.c(14, 14, 21), MapImage.c(18, 17, 26), MapImage.c(21, 20, 31), MapImage.c(11, 10, 16), MapImage.c(79, 1, 0), MapImage.c(96, 1, 0), MapImage.c(112, 2, 0), MapImage.c(59, 1, 0)};
    private static final HashMap<Character, Byte> colorCodes = new HashMap<Character, Byte>(){
        {
            this.put(Character.valueOf('0'), MapImage.matchColor(new Color(0, 0, 0)));
            this.put(Character.valueOf('1'), MapImage.matchColor(new Color(0, 0, 190)));
            this.put(Character.valueOf('2'), MapImage.matchColor(new Color(0, 190, 0)));
            this.put(Character.valueOf('3'), MapImage.matchColor(new Color(0, 190, 190)));
            this.put(Character.valueOf('4'), MapImage.matchColor(new Color(190, 0, 0)));
            this.put(Character.valueOf('5'), MapImage.matchColor(new Color(190, 0, 190)));
            this.put(Character.valueOf('6'), MapImage.matchColor(new Color(217, 163, 52)));
            this.put(Character.valueOf('7'), MapImage.matchColor(new Color(190, 190, 190)));
            this.put(Character.valueOf('8'), MapImage.matchColor(new Color(63, 63, 63)));
            this.put(Character.valueOf('9'), MapImage.matchColor(new Color(63, 63, 254)));
            this.put(Character.valueOf('a'), MapImage.matchColor(new Color(63, 254, 63)));
            this.put(Character.valueOf('b'), MapImage.matchColor(new Color(63, 254, 254)));
            this.put(Character.valueOf('c'), MapImage.matchColor(new Color(254, 63, 63)));
            this.put(Character.valueOf('d'), MapImage.matchColor(new Color(254, 63, 254)));
            this.put(Character.valueOf('e'), MapImage.matchColor(new Color(254, 254, 63)));
            this.put(Character.valueOf('f'), MapImage.matchColor(new Color(255, 255, 255)));
        }
    };
    protected int offset;
    private byte[] data;
    private int width;
    private int height;

    public MapImage() {
        this(128, 128);
    }

    public MapImage(int width, int height) {
        this.data = new byte[width * height];
        this.width = width;
        this.height = height;
    }

    public MapImage(int[] size) {
        this(size[0], size[1]);
    }

    public MapImage(URL url) throws IOException {
        BufferedImage img = ImageIO.read(url);
        this.width = ((Image)img).getWidth(null);
        this.height = ((Image)img).getHeight(null);
        this.data = MapImage.imageToBytes(img);
    }

    public MapImage(File file) throws IOException {
        BufferedImage img = ImageIO.read(file);
        this.width = ((Image)img).getWidth(null);
        this.height = ((Image)img).getHeight(null);
        this.data = MapImage.imageToBytes(img);
    }

    public static void init() {
    }

    private static Color c(int r, int g, int b) {
        return new Color(r, g, b);
    }

    private static double getDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) * 0.5;
        double r = c1.getRed() - c2.getRed();
        double g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean * 0.00390625;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) * 0.00390625;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }

    private static byte[] imageToBytes(Image image) {
        BufferedImage temp = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics = temp.createGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        int[] pixels = new int[temp.getWidth() * temp.getHeight()];
        temp.getRGB(0, 0, temp.getWidth(), temp.getHeight(), pixels, 0, temp.getWidth());
        byte[] result = new byte[temp.getWidth() * temp.getHeight()];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = MapImage.matchColor(new Color(pixels[i], true));
        }
        return result;
    }

    public static byte matchColor(Color color) {
        if (color.getAlpha() < 128) {
            return 0;
        }
        int index = 0;
        double best = Double.MAX_VALUE;
        for (int i = 4; i < colors.length; ++i) {
            double distance = MapImage.getDistance(color, colors[i]);
            if (!(distance < best)) continue;
            best = distance;
            index = i;
        }
        return (byte)(index < 128 ? index : index - 256);
    }

    public static Color getColor(byte id) {
        int index = id;
        if (index < 0) {
            index = 256 + id;
        }
        return colors[index];
    }

    public byte[] getData() {
        return this.data;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void clear() {
        Arrays.fill(this.data, (byte)0);
    }

    public void fill(byte color) {
        Arrays.fill(this.data, color);
    }

    public void drawImg(MapImage img, int x, int y) {
        if (x >= this.width || y >= this.height) {
            return;
        }
        int maxX = Math.min(this.width, x + img.width);
        int maxY = Math.min(this.height, y + img.height);
        if (maxX <= 0 || maxY <= 0) {
            return;
        }
        int posX = Math.max(0, x);
        int posY = Math.max(0, y);
        for (int i = posX; i < maxX; ++i) {
            for (int j = posY; j < maxY; ++j) {
                int source = i - x + (j - y) * img.width;
                if (img.data[source] == 0) continue;
                this.data[i + j * this.width] = img.data[source];
            }
        }
    }

    public int drawString(MapFont font, byte color, String str, int x, int y) {
        MapFont.MapChar c;
        for (int i = 0; i < str.length() && x < this.width; x += c.getWidth() + font.getSpace(), ++i) {
            c = font.getChar(str.charAt(i));
            boolean[] data = c.getData();
            for (int j = 0; j < c.getWidth(); ++j) {
                int a = j + x;
                for (int k = 0; k < c.getHeight(); ++k) {
                    int b = k + y + c.getBase();
                    if (a < 0 || a >= this.width || b < 0 || b >= this.height || !data[j + k * c.getWidth()]) continue;
                    this.data[a + b * this.width] = color;
                }
            }
        }
        return x;
    }

    public int drawColorString(MapFont font, byte color, String str, int x, int y, char token) {
        byte currentColor = color;
        int first = 0;
        int next = str.indexOf(167);
        while (next >= 0) {
            if (first != next) {
                String part = str.substring(first, next);
                x = this.drawString(font, currentColor, part, x, y);
            }
            first = next + 2;
            char c = str.charAt(next + 1);
            if (colorCodes.containsKey(Character.valueOf(c))) {
                currentColor = colorCodes.get(Character.valueOf(c));
            } else if (c == 'r') {
                currentColor = color;
            }
            next = str.indexOf(167, first);
        }
        if (first < str.length()) {
            x = this.drawString(font, color, str.substring(first), x, y);
        }
        return x;
    }

    public void drawTo(MapCanvas canvas, int x, int y) {
        for (int i = 0; i < this.data.length; ++i) {
            int a = i % this.width;
            int b = i / this.width;
            canvas.setPixel(a + x, b + y, this.data[i]);
        }
    }
}

