/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.config.parse;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import studio.magemonkey.codex.mccore.config.parse.NumberParser;
import studio.magemonkey.codex.mccore.config.parse.YAMLParser;

public class DataSection {
    private final YAMLParser yamlParser = new YAMLParser();
    private final HashMap<String, List<String>> comments = new HashMap();
    private final HashMap<String, Object> data = new HashMap();
    private final ArrayList<String> keys = new ArrayList();

    public void clear() {
        this.keys.clear();
        this.comments.clear();
        this.data.clear();
    }

    public List<String> keys() {
        return new ArrayList<String>(this.keys);
    }

    public int size() {
        return this.keys.size();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.data.entrySet();
    }

    public Collection<Object> values() {
        return this.data.values();
    }

    public void addComment(String key, String comment) {
        if (!this.comments.containsKey(key)) {
            this.comments.put(key, new ArrayList());
        }
        this.comments.get(key).add(comment);
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
    }

    public boolean hasComment(String key) {
        return this.comments.containsKey(key);
    }

    public List<String> getComments(String key) {
        return this.comments.get(key);
    }

    public void setComments(String key, List<String> comments) {
        ArrayList<String> list = new ArrayList<String>(comments.size());
        list.addAll(comments);
        this.comments.put(key, list);
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
    }

    public void clearComments(String key) {
        this.comments.remove(key);
    }

    public void clearAllComments(boolean deep) {
        this.comments.clear();
        if (deep) {
            for (Object value : this.data.values()) {
                if (!(value instanceof DataSection)) continue;
                ((DataSection)value).clearAllComments(true);
            }
        }
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.remove(key);
        } else if (value instanceof Map) {
            DataSection section = this.createSection(key);
            Map map = (Map)value;
            for (Map.Entry k : map.entrySet()) {
                section.set(k.getKey().toString(), k.getValue().toString());
            }
        } else {
            this.data.put(key, value);
            if (!this.keys.contains(key)) {
                this.keys.add(key);
            }
        }
    }

    public void checkDefault(String key, Object defaultValue) {
        if (!this.has(key)) {
            this.set(key, defaultValue);
        }
    }

    public DataSection createSection(String key) {
        DataSection section = new DataSection();
        this.data.put(key, section);
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
        return section;
    }

    public DataSection defaultSection(String key) {
        if (this.isSection(key)) {
            return this.getSection(key);
        }
        return this.createSection(key);
    }

    public Object remove(String key) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            if (section != null) {
                return section.remove(pieces[1]);
            }
            return null;
        }
        this.keys.remove(key);
        this.comments.remove(key);
        return this.data.remove(key);
    }

    public boolean isSection(String key) {
        return this.getSection(key) != null;
    }

    public boolean has(String key) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section != null && section.has(pieces[1]);
        }
        return this.data.containsKey(key);
    }

    public boolean isList(String key) {
        return this.getList(key, null) != null;
    }

    public boolean isNumber(String key) {
        return this.getDouble(key, Double.MAX_VALUE) != Double.MAX_VALUE;
    }

    public DataSection getSection(String key) {
        Object obj;
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? null : section.getSection(pieces[1]);
        }
        if (this.data.containsKey(key) && (obj = this.data.get(key)) instanceof DataSection) {
            return (DataSection)obj;
        }
        return null;
    }

    public char getChar(String key) {
        return this.getChar(key, '\u0000');
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public List<String> getList(String key) {
        return this.getList(key, new ArrayList<String>());
    }

    public char getChar(String key, char fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.getChar(pieces[1], fallback);
        }
        String str = this.getString(key);
        if (str == null || str.isEmpty()) {
            return fallback;
        }
        return str.charAt(0);
    }

    public String getString(String key, String fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.getString(pieces[1], fallback);
        }
        if (!this.data.containsKey(key)) {
            return fallback;
        }
        return this.data.get(key).toString();
    }

    public boolean getBoolean(String key, boolean fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.getBoolean(pieces[1], fallback);
        }
        if (!this.data.containsKey(key)) {
            return fallback;
        }
        String str = this.getString(key).toLowerCase();
        return str.equals("true") || str.equals("yes") || str.equals("t") || str.equals("y") || fallback && !str.equals("false") && !str.equals("no") && !str.equals("f") && !str.equals("n");
    }

    public byte getByte(String key, byte fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.getByte(pieces[1], fallback);
        }
        if (!this.data.containsKey(key)) {
            return fallback;
        }
        Object obj = this.data.get(key);
        try {
            return (byte)NumberParser.parseInt(obj.toString());
        }
        catch (Exception ex) {
            return fallback;
        }
    }

    public short getShort(String key, short fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.getShort(pieces[1], fallback);
        }
        if (!this.data.containsKey(key)) {
            return fallback;
        }
        Object obj = this.data.get(key);
        try {
            return (short)NumberParser.parseInt(obj.toString());
        }
        catch (Exception ex) {
            return fallback;
        }
    }

    public int getInt(String key, int fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.getInt(pieces[1], fallback);
        }
        if (!this.data.containsKey(key)) {
            return fallback;
        }
        Object obj = this.data.get(key);
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (Exception ex) {
            return fallback;
        }
    }

    public float getFloat(String key, float fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.getFloat(pieces[1], fallback);
        }
        if (!this.data.containsKey(key)) {
            return -1.0f;
        }
        Object obj = this.data.get(key);
        try {
            return (float)NumberParser.parseDouble(obj.toString());
        }
        catch (Exception ex) {
            return fallback;
        }
    }

    public double getDouble(String key, double fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.getDouble(pieces[1], fallback);
        }
        if (!this.data.containsKey(key)) {
            return fallback;
        }
        Object obj = this.data.get(key);
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (Exception ex) {
            return fallback;
        }
    }

    public List<String> getList(String key, List<String> fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.getList(pieces[1], fallback);
        }
        if (!this.data.containsKey(key)) {
            return fallback;
        }
        Object obj = this.data.get(key);
        if (obj instanceof List) {
            List l = (List)obj;
            ArrayList<String> list = new ArrayList<String>(l.size());
            for (Object o : l) {
                if (o == null) continue;
                list.add(o.toString());
            }
            return list;
        }
        return fallback;
    }

    public Object get(String key) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? null : section.get(pieces[1]);
        }
        return this.data.get(key);
    }

    public Object get(String key, Object fallback) {
        if (key.contains(".")) {
            String[] pieces = key.split("\\.", 2);
            DataSection section = this.getSection(pieces[0]);
            return section == null ? fallback : section.get(pieces[1]);
        }
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        return fallback;
    }

    public void applyDefaults(DataSection defaults) {
        for (String key : defaults.keys) {
            if (defaults.comments.containsKey(key)) {
                this.setComments(key, defaults.comments.get(key));
            }
            if (defaults.isSection(key)) {
                DataSection section = this.defaultSection(key);
                section.applyDefaults(defaults.getSection(key));
                continue;
            }
            this.checkDefault(key, defaults.get(key));
        }
    }

    public void trim(DataSection defaults) {
        ArrayList<String> copy = new ArrayList<String>(this.keys);
        for (String key : copy) {
            if (key.equals("yields")) continue;
            if (!defaults.has(key)) {
                this.remove(key);
                continue;
            }
            if (!defaults.isSection(key)) continue;
            if (this.isSection(key)) {
                this.getSection(key).trim(defaults.getSection(key));
                continue;
            }
            this.remove(key);
        }
    }

    public void dump(String path) {
        this.yamlParser.save(this, path);
    }

    public void dump(File file) {
        this.yamlParser.save(this, file);
    }

    public void dump(BufferedWriter write) throws IOException {
        this.yamlParser.save(this, write);
    }

    public String toString() {
        return this.toString('\'');
    }

    public String toString(char quote) {
        StringBuilder builder = new StringBuilder();
        this.yamlParser.dump(this, builder, 0, quote);
        return builder.toString();
    }
}

