/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.chat;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.mccore.chat.Chat;
import studio.magemonkey.codex.mccore.chat.ChatData;
import studio.magemonkey.codex.mccore.chat.ChatNodes;

class PrefixCommand<P extends CodexPlugin<P>>
extends ISubCommand<P> {
    PrefixCommand(P plugin) {
        super(plugin, List.of("prefix"), ChatNodes.PREFIX.getNode());
    }

    @Override
    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        ChatData data = Chat.getPlayerData(sender.getName());
        if (data != null && args.length == 2) {
            if (data.hasPrefix(args[1])) {
                data.setPrefix(args[1]);
                sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "The prefix has been set!");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "You do not have that prefix!");
            }
        } else {
            this.printUsage(sender);
        }
    }

    @Override
    @NotNull
    public String usage() {
        return "<prefix>";
    }

    @Override
    @NotNull
    public String description() {
        return "Sets your prefix";
    }

    @Override
    public boolean playersOnly() {
        return true;
    }
}

