/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.chat;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.mccore.chat.Chat;
import studio.magemonkey.codex.mccore.chat.ChatData;
import studio.magemonkey.codex.mccore.chat.ChatNodes;

class NameCommand<P extends CodexPlugin<P>>
extends ISubCommand<P> {
    NameCommand(P plugin) {
        super(plugin, List.of("name"), ChatNodes.NAME.getNode());
    }

    @Override
    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        ChatData data = Chat.getPlayerData(sender.getName());
        if (data != null && args.length > 1) {
            StringBuilder name = new StringBuilder();
            String[] temp = new String[args.length - 1];
            System.arraycopy(args, 1, temp, 0, args.length - 1);
            for (String piece : temp) {
                name.append(piece.replace('&', '\u00a7')).append(" ");
            }
            name = new StringBuilder(name.substring(0, name.length() - 2));
            data.setDisplayName(name.toString());
            sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Your name has been set");
        } else {
            this.printUsage(sender);
        }
    }

    @Override
    @NotNull
    public String description() {
        return "Sets your display name";
    }

    @Override
    @NotNull
    public String usage() {
        return "<name>";
    }

    @Override
    public boolean playersOnly() {
        return true;
    }
}

