/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.chat;

import java.util.Hashtable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.mccore.chat.ChatData;
import studio.magemonkey.codex.mccore.chat.Prefix;
import studio.magemonkey.codex.mccore.config.Config;

public class Chat {
    static Hashtable<String, ChatData> players = new Hashtable();

    public static ChatData getPlayerData(String playerName) {
        if (!players.containsKey(playerName = playerName.toLowerCase())) {
            CodexEngine core = CodexEngine.get();
            Config configFile = core.getConfigFile(core, "data");
            ChatData data = new ChatData((ConfigurationSection)configFile.getConfig(), playerName);
            configFile.addSavable(data, playerName + ".");
            players.put(playerName, data);
        }
        return players.get(playerName);
    }

    public static void unlockPrefix(Prefix prefix, boolean apply) {
        for (ChatData data : players.values()) {
            data.unlockPrefix(prefix, apply);
        }
    }

    public static void removePrefix(String pluginName, String prefix) {
        for (ChatData data : players.values()) {
            data.removePrefix(pluginName, prefix);
        }
    }

    public static void clearPluginPrefixes(String pluginName) {
        for (ChatData data : players.values()) {
            data.clearPluginPrefix(pluginName);
        }
    }

    public static void sendMessage(String permission, String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
        }
    }

    public static void sendMessage(Location point1, Location point2, String message) {
        if (point1.getWorld() != point2.getWorld()) {
            return;
        }
        Chat.sendMessage(point1, point2.getBlockX() - point1.getBlockX(), point2.getBlockY() - point1.getBlockY(), point2.getBlockZ() - point1.getBlockZ(), message);
    }

    public static void sendMessage(Location point, int width, int height, int depth, String message) {
        if (width < 0) {
            point.setX(point.getX() + (double)width);
        }
        if (height < 0) {
            point.setY(point.getY() + (double)height);
        }
        if (depth < 0) {
            point.setZ(point.getZ() + (double)depth);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location loc = player.getLocation();
            if (!(loc.getX() >= point.getX()) || !(loc.getY() >= point.getY()) || !(loc.getZ() >= point.getZ()) || !(loc.getX() <= point.getX() + (double)Math.abs(width)) || !(loc.getY() <= point.getY() + (double)Math.abs(height)) || !(loc.getZ() <= point.getZ() + (double)Math.abs(depth))) continue;
            player.sendMessage(message);
        }
    }

    public static void sendMessage(Location center, int radius, boolean sphere, String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location loc = player.getLocation();
            if (!sphere) {
                loc.setY(center.getY());
            }
            if (!(loc.distanceSquared(center) < (double)(radius * radius))) continue;
            player.sendMessage(message);
        }
    }
}

