/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.placeholder;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import studio.magemonkey.codex.legacy.placeholder.BasePlaceholderItem;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderData;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderItem;

public class PlaceholderType<T> {
    private static final Map<String, PlaceholderType<?>> types = new HashMap(5, 0.1f);
    private static final Map<String, GlobalPlaceholderType<?>> globalTypes = new HashMap(5, 0.1f);
    public static final PlaceholderType<Object> OBJECT = PlaceholderType.create("", Object.class, new PlaceholderType[0]);
    private final String id;
    private final Class<T> type;
    private final Map<String, PlaceholderItem<T>> items = new TreeMap<String, PlaceholderItem<T>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ChildPlaceholderItem<?, ?>> cachedChildItems = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ChildPlaceholderType<?, ?>> childTypes = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Set<PlaceholderType<? super T>> superTypes;

    public static <T> PlaceholderItem<T> getQualifiedItem(String fullId) {
        if (!fullId.contains(".")) {
            return null;
        }
        String[] split = new String[]{fullId.substring(0, fullId.indexOf(46)), fullId.substring(fullId.indexOf(46) + 1)};
        if (!types.containsKey(split[0])) {
            return null;
        }
        PlaceholderType<?> type = types.get(split[0]);
        return type.getItem(split[1]);
    }

    @SafeVarargs
    public static <T> PlaceholderType<T> create(String id, Class<T> clazz, PlaceholderType<? super T> ... superTypes) {
        PlaceholderType<T> type = new PlaceholderType<T>(id, clazz, superTypes);
        types.put(type.getId(), type);
        return type;
    }

    @SafeVarargs
    public static <T> GlobalPlaceholderType<T> createGlobal(String id, Class<T> clazz, Supplier<T> globalSupplier, PlaceholderType<? super T> ... superTypes) {
        GlobalPlaceholderType<T> type = new GlobalPlaceholderType<T>(id, clazz, globalSupplier, superTypes);
        types.put(type.getId(), type);
        globalTypes.put(type.getId(), type);
        return type;
    }

    public static BaseComponent replaceGlobal(BaseComponent component, Map<String, Collection<PlaceholderData<?>>> placeholders) {
        component = component.duplicate();
        for (Map.Entry<String, GlobalPlaceholderType<?>> entry : globalTypes.entrySet()) {
            Collection<PlaceholderData<?>> placeholderDatas = placeholders.get(entry.getKey());
            if (placeholderDatas == null) continue;
            Object o = entry.getValue().globalSupplier.get();
            for (PlaceholderData<?> placeholderData : placeholderDatas) {
                placeholderData.replace(component, o);
            }
        }
        return component;
    }

    public static <T> PlaceholderType<? super T> get(String id) {
        return types.get(id);
    }

    public PlaceholderType(String id, Class<T> type) {
        this.id = id.intern();
        this.type = type;
        this.superTypes = new HashSet<PlaceholderType<? super T>>(3);
    }

    public PlaceholderType(String id, Class<T> type, Collection<PlaceholderType<? super T>> superTypes) {
        this.id = id.intern();
        this.type = type;
        this.superTypes = new HashSet<PlaceholderType<T>>(superTypes);
    }

    @SafeVarargs
    public PlaceholderType(String id, Class<T> type, PlaceholderType<? super T> ... superTypes) {
        this.id = id.intern();
        this.type = type;
        this.superTypes = Sets.newHashSet((Object[])superTypes);
    }

    public void registerItem(PlaceholderItem<T> item) {
        this.items.put(item.getId(), item);
    }

    public PlaceholderItem<T> registerItem(PlaceholderType<T> type, String id, Function<T, Object> func) {
        BasePlaceholderItem<T> item = new BasePlaceholderItem<T>(type, id, func);
        this.registerItem(item);
        return item;
    }

    public PlaceholderItem<T> registerItem(String id, Function<T, Object> func) {
        BasePlaceholderItem<T> item = new BasePlaceholderItem<T>(this, id, func);
        this.registerItem(item);
        return item;
    }

    public <C> void registerChild(String name, PlaceholderType<C> type, Function<T, C> converter) {
        this.childTypes.put(name, new ChildPlaceholderType<T, C>(this, type, converter));
    }

    public PlaceholderItem<?> getItem(String id) {
        PlaceholderItem<?> item = this.items.get(id);
        if (item == null) {
            item = (PlaceholderItem<?>)this.cachedChildItems.get(id);
            if (item != null) {
                return item;
            }
        } else {
            return item;
        }
        if (!this.superTypes.isEmpty()) {
            PlaceholderType<T> type;
            Iterator<PlaceholderType<T>> iterator = this.superTypes.iterator();
            while (iterator.hasNext() && (item = (type = iterator.next()).getItem(id)) == null) {
            }
        }
        if (item == null) {
            int index = id.indexOf(46);
            if (index == -1) {
                return null;
            }
            String childTypeID = id.substring(0, index);
            ChildPlaceholderType<?, ?> childType = this.childTypes.get(childTypeID);
            if (childType == null) {
                return null;
            }
            ChildPlaceholderItem childItem = new ChildPlaceholderItem(childType, childType.type.getItem(id.substring(index + 1)));
            item = childItem;
            this.cachedChildItems.put(id, childItem);
        }
        return item;
    }

    public String getId() {
        return this.id;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlaceholderType)) {
            return false;
        }
        PlaceholderType that = (PlaceholderType)o;
        return this.id.equals(that.id) && this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("type", this.type).append("id", (Object)this.id).toString();
    }

    static class GlobalPlaceholderType<T>
    extends PlaceholderType<T> {
        protected final Supplier<T> globalSupplier;

        GlobalPlaceholderType(String id, Class<T> type, Supplier<T> globalSupplier) {
            super(id, type);
            this.globalSupplier = globalSupplier;
        }

        GlobalPlaceholderType(String id, Class<T> type, Supplier<T> globalSupplier, Collection<PlaceholderType<? super T>> superTypes) {
            super(id, type, superTypes);
            this.globalSupplier = globalSupplier;
        }

        @SafeVarargs
        GlobalPlaceholderType(String id, Class<T> type, Supplier<T> globalSupplier, PlaceholderType<? super T> ... superTypes) {
            super(id, type, superTypes);
            this.globalSupplier = globalSupplier;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("globalSupplier", this.globalSupplier).toString();
        }
    }

    private static class ChildPlaceholderType<PARENT, CHILD> {
        private final PlaceholderType<PARENT> parent;
        private final PlaceholderType<CHILD> type;
        private final Function<PARENT, CHILD> function;

        private ChildPlaceholderType(PlaceholderType<PARENT> parent, PlaceholderType<CHILD> type, Function<PARENT, CHILD> function) {
            this.parent = parent;
            this.type = type;
            this.function = function;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("type", this.type).append("function", this.function).toString();
        }
    }

    private static class ChildPlaceholderItem<PARENT, CHILD>
    implements PlaceholderItem<PARENT> {
        private final ChildPlaceholderType<PARENT, CHILD> type;
        private final PlaceholderItem<CHILD> item;

        private ChildPlaceholderItem(ChildPlaceholderType<PARENT, CHILD> type, PlaceholderItem<CHILD> item) {
            this.type = type;
            this.item = item;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("type", this.type).append("item", this.item).toString();
        }

        @Override
        public PlaceholderType<PARENT> getType() {
            return this.type.parent;
        }

        @Override
        public String getId() {
            return this.item.getId();
        }

        @Override
        public Object apply(PARENT obj, Object[] args) {
            return this.item.apply(this.type.function.apply(obj), args);
        }

        @Override
        public String getFullId() {
            return this.type.parent.id + "." + this.type.type.id + "." + this.item.getId();
        }
    }

    private static class CIStringWrapper {
        private final String wrapped;

        private CIStringWrapper(String wrapped) {
            this.wrapped = wrapped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof String) {
                return this.wrapped.equalsIgnoreCase((String)o);
            }
            if (!(o instanceof CIStringWrapper)) {
                return false;
            }
            CIStringWrapper that = (CIStringWrapper)o;
            return this.wrapped.equalsIgnoreCase(that.wrapped);
        }

        public int hashCode() {
            return this.wrapped.toLowerCase().hashCode();
        }

        public String toString() {
            return this.wrapped;
        }
    }
}

