/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.Codex;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.CodexItemException;
import studio.magemonkey.codex.api.items.providers.VanillaProvider;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.legacy.item.BookDataBuilder;
import studio.magemonkey.codex.legacy.item.DataBuilder;
import studio.magemonkey.codex.legacy.item.EnchantmentStorageBuilder;
import studio.magemonkey.codex.legacy.item.FireworkBuilder;
import studio.magemonkey.codex.legacy.item.FireworkEffectBuilder;
import studio.magemonkey.codex.legacy.item.LeatherArmorBuilder;
import studio.magemonkey.codex.legacy.item.MapBuilder;
import studio.magemonkey.codex.legacy.item.PotionDataBuilder;
import studio.magemonkey.codex.legacy.item.SkullBuilder;
import studio.magemonkey.codex.legacy.utils.Utils;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.ItemUtils;
import studio.magemonkey.codex.util.SerializationBuilder;

@SerializableAs(value="Codex_Item")
public class ItemBuilder
implements ConfigurationSerializable {
    protected ItemType material = new VanillaProvider.VanillaItemType(Material.AIR);
    protected int amount = 1;
    protected short durability = 0;
    protected boolean unbreakable = false;
    protected String name;
    protected List<String> lore = new ArrayList<String>(5);
    protected Map<Enchantment, Integer> enchants = new LinkedHashMap<Enchantment, Integer>(3);
    protected DataBuilder dataBuilder = null;
    protected List<ItemFlag> flags = new ArrayList<ItemFlag>(5);
    protected int modelData = -1;

    @Deprecated
    public ItemBuilder(Map<String, Object> map) {
        DeserializationWorker w = DeserializationWorker.start(map);
        String matString = w.getString("material", "VANILLA_air");
        try {
            this.material = CodexEngine.get().getItemManager().getItemType(matString);
        }
        catch (CodexItemException e) {
            Codex.warn("Invalid item type: " + matString + ". Using AIR instead.");
        }
        this.amount = w.getInt("amount", 1);
        this.durability = w.getShort("durability");
        this.name = w.getString("name", null);
        this.unbreakable = w.getBoolean("unbreakable", false);
        this.lore = w.getStringList("lore", new ArrayList<String>(3));
        this.flags = w.getStringList("flags", new ArrayList<String>(1)).stream().map(s -> ItemFlag.valueOf((String)s.toUpperCase())).collect(Collectors.toList());
        Map<String, Object> enchantsMap = w.getSection("enchants");
        if (enchantsMap != null) {
            for (Map.Entry<String, Object> entry : enchantsMap.entrySet()) {
                this.enchants.put(Enchantment.getByName((String)entry.getKey()), ((Number)entry.getValue()).intValue());
            }
        }
        this.dataBuilder = DataBuilder.build(w.getTypedObject("data", new HashMap(1)));
        this.modelData = w.getInt("modelData", -1);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("material", (Object)this.material).append("amount", this.amount).append("durability", this.durability).append("name", (Object)this.name).append("lore", this.lore).append("enchants", this.enchants).append("dataBuilder", (Object)this.dataBuilder).toString();
    }

    public ItemBuilder unbreakable(boolean flag) {
        this.unbreakable = flag;
        return this;
    }

    public ItemBuilder unbreakable(ItemMeta meta) {
        this.unbreakable = meta.isUnbreakable();
        return this;
    }

    public ItemBuilder flag(ItemFlag flag) {
        this.flags.add(flag);
        return this;
    }

    public ItemBuilder clearFlags() {
        this.flags.clear();
        return this;
    }

    public ItemBuilder flag(ItemFlag ... flags) {
        Collections.addAll(this.flags, flags);
        return this;
    }

    public ItemBuilder flag(ItemMeta meta) {
        this.flags.addAll(meta.getItemFlags());
        return this;
    }

    public ItemBuilder material(Material material) {
        this.material = new VanillaProvider.VanillaItemType(material);
        return this;
    }

    public ItemBuilder material(ItemStack source) {
        this.material = CodexEngine.get().getItemManager().getMainItemType(source);
        return this;
    }

    public ItemBuilder durability(int damage) {
        return this.durability((short)damage);
    }

    public ItemBuilder durability(short damage) {
        this.durability = damage;
        return this;
    }

    public ItemBuilder durability(ItemStack source) {
        this.durability = source.getDurability();
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.amount = amount;
        return this;
    }

    public ItemBuilder amount(ItemStack source) {
        this.amount = source.getAmount();
        return this;
    }

    public ItemBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ItemBuilder name(ItemStack source) {
        this.name = VersionManager.getCompat().getItemName(source);
        return this;
    }

    public ItemBuilder clearName() {
        this.name = null;
        return this;
    }

    public ItemBuilder lore(List<String> lore) {
        this.lore = lore == null ? new ArrayList<String>(5) : new ArrayList<String>(lore);
        return this;
    }

    public ItemBuilder lore(ItemMeta source) {
        this.lore = source.hasLore() ? new ArrayList<String>(source.getLore()) : new ArrayList(5);
        return this;
    }

    public ItemBuilder newLoreLine(String lore) {
        this.lore.add(lore);
        return this;
    }

    public ItemBuilder newLoreLine(Object lore) {
        this.lore.add(lore.toString());
        return this;
    }

    public ItemBuilder newLoreLine(Collection<String> lore) {
        this.lore.addAll(lore);
        return this;
    }

    public ItemBuilder newLoreLine(String ... lore) {
        this.newLoreLine(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder insertLoreLine(int index, String lore) {
        this.lore.add(index, lore);
        return this;
    }

    public ItemBuilder insertLoreLine(int index, Collection<String> lore) {
        this.lore.addAll(index, lore);
        return this;
    }

    public ItemBuilder insertLoreLine(int index, String ... lore) {
        this.insertLoreLine(index, Arrays.asList(lore));
        return this;
    }

    public ItemBuilder removeLoreLine(String lore) {
        this.lore.remove(lore);
        return this;
    }

    public ItemBuilder removeLoreLine(Collection<String> lore) {
        this.lore.removeAll(lore);
        return this;
    }

    public ItemBuilder removeLoreLine(String ... lore) {
        this.removeLoreLine(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder removeLoreLine(int lore) {
        this.lore.remove(lore);
        return this;
    }

    public ItemBuilder setLoreLine(int index, String lore) {
        this.lore.set(index, lore);
        return this;
    }

    public ItemBuilder clearLore() {
        this.lore.clear();
        return this;
    }

    public ItemBuilder enchant(Map<Enchantment, Integer> enchants) {
        this.enchants = new LinkedHashMap<Enchantment, Integer>(enchants);
        return this;
    }

    public ItemBuilder enchant(ItemMeta source) {
        this.enchants = source.hasEnchants() ? new LinkedHashMap<Enchantment, Integer>(source.getEnchants()) : new LinkedHashMap(3);
        return this;
    }

    public ItemBuilder enchant(Enchantment enchantment, int power) {
        this.enchants.put(enchantment, power);
        return this;
    }

    public ItemBuilder enchant(Enchantment enchantment) {
        this.enchant(enchantment, 1);
        return this;
    }

    public ItemBuilder unEnchant(Enchantment enchantment) {
        this.enchants.remove(enchantment);
        return this;
    }

    public ItemBuilder clearEnchants() {
        this.enchants.clear();
        return this;
    }

    public ItemBuilder data(DataBuilder dataBuilder) {
        this.dataBuilder = dataBuilder;
        return this;
    }

    public ItemBuilder data(ItemMeta meta) {
        if (meta instanceof BookMeta) {
            this.dataBuilder = new BookDataBuilder();
        } else if (meta instanceof EnchantmentStorageMeta) {
            this.dataBuilder = new EnchantmentStorageBuilder();
        } else if (meta instanceof FireworkEffectMeta) {
            this.dataBuilder = new FireworkEffectBuilder();
        } else if (meta instanceof FireworkMeta) {
            this.dataBuilder = new FireworkBuilder();
        } else if (meta instanceof LeatherArmorMeta) {
            this.dataBuilder = new LeatherArmorBuilder();
        } else if (meta instanceof MapMeta) {
            this.dataBuilder = new MapBuilder();
        } else if (meta instanceof PotionMeta) {
            this.dataBuilder = new PotionDataBuilder();
        } else if (meta instanceof SkullMeta) {
            this.dataBuilder = new SkullBuilder();
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.use(meta);
        }
        if (meta.hasCustomModelData()) {
            this.modelData = meta.getCustomModelData();
        }
        return this;
    }

    public ItemStack build() {
        ItemStack item = this.material.create();
        item.setAmount(this.amount);
        ItemMeta meta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getItemFactory().getItemMeta(item.getType());
        item.setDurability(this.durability);
        if (this.name != null) {
            meta.setDisplayName(Utils.fixColors(this.name));
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            meta.addItemFlags(this.flags.toArray(new ItemFlag[this.flags.size()]));
        }
        if (this.lore != null && !this.lore.isEmpty()) {
            ArrayList<String> lore = new ArrayList<String>(this.lore.size() + 5);
            for (String string : this.lore) {
                Collections.addAll(lore, string.split("\n"));
            }
            meta.setLore(Utils.fixColors(lore));
        }
        if (this.enchants != null) {
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta storage = (EnchantmentStorageMeta)meta;
                for (Map.Entry entry : this.enchants.entrySet()) {
                    storage.addStoredEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                }
            } else {
                for (Map.Entry<Enchantment, Integer> entry : this.enchants.entrySet()) {
                    meta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
                }
            }
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.apply(meta);
        }
        if (this.modelData != -1) {
            meta.setCustomModelData(Integer.valueOf(this.modelData));
        }
        item.setItemMeta(meta);
        return item;
    }

    public ItemBuilder reset() {
        this.material = new VanillaProvider.VanillaItemType(Material.AIR);
        this.amount = 1;
        this.durability = 0;
        this.name = null;
        if (this.flags != null) {
            this.flags.clear();
        } else {
            this.flags = new ArrayList<ItemFlag>(5);
        }
        if (this.lore != null) {
            this.lore.clear();
        } else {
            this.lore = new ArrayList<String>(5);
        }
        if (this.enchants != null) {
            this.enchants.clear();
        } else {
            this.enchants = new LinkedHashMap<Enchantment, Integer>(3);
        }
        this.dataBuilder = null;
        this.unbreakable = false;
        this.modelData = -1;
        return this;
    }

    @NotNull
    public Map<String, Object> serialize() {
        SerializationBuilder b = SerializationBuilder.start(7);
        b.append("material", (Object)this.material.getNamespacedID());
        b.append("amount", (Object)this.amount);
        b.append("durability", (Object)this.durability);
        b.append("unbreakable", (Object)this.unbreakable);
        b.append("name", (Object)this.name);
        b.append("lore", this.lore);
        b.append("flags", this.flags == null ? new ArrayList(1) : this.flags.stream().map(Enum::name).collect(Collectors.toList()));
        SerializationBuilder enchant = SerializationBuilder.start(this.enchants.size());
        for (Map.Entry<Enchantment, Integer> entry : this.enchants.entrySet()) {
            enchant.append(entry.getKey().getName(), (Object)entry.getValue());
        }
        b.append("enchants", enchant);
        b.append("data", this.dataBuilder == null ? null : this.dataBuilder.serialize());
        if (this.modelData != -1) {
            b.append("modelData", (Object)this.modelData);
        }
        return b.build();
    }

    public static ItemBuilder newItem(Material material) {
        return new ItemBuilder().material(material);
    }

    public static ItemBuilder newItem(ItemStack itemStack) {
        if (itemStack == null) {
            return new ItemBuilder();
        }
        ItemBuilder itemBuilder = new ItemBuilder().material(itemStack).amount(itemStack).durability(itemStack).name(itemStack);
        ItemMeta meta = ItemUtils.getItemMeta(itemStack);
        if (meta == null) {
            return itemBuilder;
        }
        return itemBuilder.lore(meta).enchant(meta).flag(meta).unbreakable(meta).data(meta);
    }

    @Generated
    public ItemBuilder() {
    }

    @Generated
    public ItemType getMaterial() {
        return this.material;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public short getDurability() {
        return this.durability;
    }

    @Generated
    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public Map<Enchantment, Integer> getEnchants() {
        return this.enchants;
    }

    @Generated
    public DataBuilder getDataBuilder() {
        return this.dataBuilder;
    }

    @Generated
    public List<ItemFlag> getFlags() {
        return this.flags;
    }
}

