/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.items;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.api.items.providers.ICodexItemProvider;
import studio.magemonkey.codex.api.items.providers.ItemsAdderProvider;
import studio.magemonkey.codex.api.items.providers.NexoProvider;
import studio.magemonkey.codex.api.items.providers.OraxenProvider;
import studio.magemonkey.codex.api.items.providers.VanillaProvider;

public class CodexItemManager {
    private final CodexEngine plugin;
    private Logger log;
    private final Map<String, ICodexItemProvider<?>> providers = new LinkedHashMap();

    public static String stripPrefix(String id) {
        String[] split = id.split("_", 2);
        return split.length == 2 && CodexEngine.getEngine().getItemManager().providers.keySet().stream().anyMatch(s -> s.equalsIgnoreCase(split[0])) ? split[1] : id;
    }

    public void init() {
        this.log = this.plugin.getLogger();
        this.registerProvider("VANILLA", new VanillaProvider());
        this.registerProvider("ORAXEN", new OraxenProvider());
        this.registerProvider("NEXO", new NexoProvider());
        this.registerProvider("ITEMSADDER", new ItemsAdderProvider());
    }

    public void registerProvider(String namespace, ICodexItemProvider<?> provider) {
        if (this.providers.get(namespace = namespace.toUpperCase(Locale.US)) != null) {
            throw new IllegalArgumentException("Provider with namespace " + namespace + " already exists!");
        }
        this.providers.put(namespace, provider);
        this.log.info("[ItemManager] Successfully registered provider for " + namespace + " items");
    }

    public void unregisterProvider(Class<? extends ICodexItemProvider<?>> providerClass) {
        this.providers.entrySet().removeIf(entry -> ((ICodexItemProvider)entry.getValue()).getClass().equals(providerClass));
    }

    public ItemType getItemType(String key) throws MissingProviderException, MissingItemException {
        String namespace;
        String[] split = key.split("_", 2);
        if (split.length > 1 && this.providers.containsKey(namespace = split[0])) {
            return this.getItemType(namespace, split[1]);
        }
        return this.getItemType("VANILLA", key);
    }

    public ItemType getItemType(String namespace, String id) throws MissingProviderException, MissingItemException {
        ICodexItemProvider<?> provider = this.providers.get(namespace);
        if (provider == null) {
            throw new MissingProviderException("No provider found for namespace " + namespace + "!");
        }
        provider.assertEnabled();
        Object item = provider.getItem(id);
        if (item == null) {
            throw new MissingItemException("No item found for key " + id + "!");
        }
        return item;
    }

    @NotNull
    public Set<ItemType> getItemTypes(@Nullable ItemStack itemStack) {
        HashSet<ItemType> set = new HashSet<ItemType>();
        for (ICodexItemProvider<?> provider : this.providers.values()) {
            try {
                Object itemType = provider.getItem(itemStack);
                if (itemType == null) continue;
                set.add((ItemType)itemType);
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError) {}
        }
        return set;
    }

    @Nullable
    public ItemType getMainItemType(@Nullable ItemStack itemStack) {
        return this.getItemTypes(itemStack).stream().max(Comparator.comparing(ItemType::getCategory)).orElse(null);
    }

    public boolean isCustomItem(ItemStack item) {
        return this.providers.values().stream().anyMatch(provider -> {
            try {
                return provider.isCustomItem(item);
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
                return false;
            }
        });
    }

    public boolean isCustomItemOfId(ItemStack item, String id) {
        return this.providers.values().stream().anyMatch(provider -> {
            try {
                if (!(provider.getClass().equals(VanillaProvider.class) || id.length() >= provider.getNamespace().length() + 1 && id.substring(0, provider.getNamespace().length() + 1).equalsIgnoreCase(provider.getNamespace()))) {
                    return false;
                }
                return provider.isCustomItemOfId(item, id);
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
                return false;
            }
        });
    }

    public Collection<ICodexItemProvider<?>> getProviders() {
        return this.providers.values();
    }

    @Generated
    public CodexItemManager(CodexEngine plugin) {
        this.plugin = plugin;
    }
}

