/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.config.api;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.ILangMsg;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.util.Reflex;
import studio.magemonkey.codex.util.StringUT;

public abstract class ILangTemplate {
    protected CodexPlugin<?> plugin;
    protected JYML config;
    protected ILangTemplate parent;
    protected Map<String, String> customPlaceholders;

    public ILangTemplate(@NotNull CodexPlugin<?> plugin, @NotNull JYML config) {
        this(plugin, config, null);
    }

    public ILangTemplate(@NotNull CodexPlugin<?> plugin, @NotNull JYML config, @Nullable ILangTemplate parent) {
        this.plugin = plugin;
        this.config = config;
        this.parent = parent;
        this.customPlaceholders = new HashMap<String, String>();
    }

    public void setup() {
        this.load();
        this.setupEnums();
        this.config.saveChanges();
        for (String place : this.config.getSection("custom-placeholders")) {
            this.customPlaceholders.put("%" + place + "%", this.config.getString("custom-placeholders." + place));
        }
    }

    protected void setupEnums() {
    }

    protected void setupEnum(@NotNull Class<? extends Enum<?>> clazz) {
        if (!clazz.isEnum()) {
            return;
        }
        for (Enum<?> o : clazz.getEnumConstants()) {
            if (o == null) continue;
            String name = o.toString();
            String path = clazz.getSimpleName() + "." + name;
            String val = StringUT.capitalizeFully(name.replace("_", " "));
            this.config.addMissing(path, val);
        }
    }

    @NotNull
    public String getEnum(@NotNull Enum<?> e) {
        String path = e.getClass().getSimpleName() + "." + e.name();
        String locEnum = this.getCustom(path);
        if (locEnum == null && !this.plugin.isEngine()) {
            return CodexPlugin.getEngine().lang().getEnum(e);
        }
        return locEnum == null ? "null" : locEnum;
    }

    @Nullable
    public String getCustom(@NotNull String path) {
        String str = this.config.getString(path);
        return str == null ? str : StringUT.color(str);
    }

    @NotNull
    public Map<String, String> getCustomPlaceholders() {
        return this.customPlaceholders;
    }

    private void load() {
        for (Field field : Reflex.getFields(this.getClass())) {
            String path;
            JYML cfg;
            ILangMsg jmsg;
            if (!ILangMsg.class.isAssignableFrom(field.getType())) continue;
            try {
                jmsg = (ILangMsg)field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            jmsg.setPath(field.getName());
            if (!field.getDeclaringClass().equals(this.getClass())) {
                if (this.parent == null) continue;
                ILangMsg superField = (ILangMsg)Reflex.getFieldValue(this.parent, field.getName());
                if (superField != null) {
                    jmsg.setMsg(superField.getMsg());
                    continue;
                }
            }
            if (!(cfg = this.config).contains(path = jmsg.getPath())) {
                String msg = jmsg.getDefaultMsg();
                String[] split = msg.split("\n");
                cfg.set(path, split.length > 1 ? Arrays.asList(split) : msg);
            }
            String msgLoad = null;
            List cList = cfg.getStringList(path);
            if (!cList.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                cList.forEach(line -> {
                    if (builder.length() > 0) {
                        builder.append("\\n");
                    }
                    builder.append((String)line);
                });
                msgLoad = builder.toString();
            } else {
                msgLoad = cfg.getString(path, "");
            }
            jmsg.setMsg(msgLoad);
        }
        this.config.saveChanges();
    }
}

