/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.IGeneralCommand;
import studio.magemonkey.codex.config.legacy.LegacyConfigManager;
import studio.magemonkey.codex.util.messages.MessageData;

public class UnstuckCommand<P extends CodexPlugin<P>>
extends IGeneralCommand<P>
implements Listener {
    private final Map<UUID, LinkedList<Location>> locs = new HashMap<UUID, LinkedList<Location>>();
    private final Map<UUID, Location> warmingUp = new HashMap<UUID, Location>();
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitTask> tasks = new HashMap<UUID, BukkitTask>();
    private final FileConfiguration config;
    private final File destFile;

    public UnstuckCommand(@NotNull P plugin) {
        super(plugin, List.of("unstuck"), "codex.stuck");
        ((CodexPlugin)plugin).getPluginManager().registerEvents((Listener)this, plugin);
        this.destFile = new File(CodexEngine.get().getDataFolder(), "unstuck.log");
        this.config = LegacyConfigManager.loadConfigFile(this.destFile, null);
    }

    private void saveFile() {
        try {
            this.config.save(this.destFile);
        }
        catch (IOException e) {
            CodexEngine.get().getLogger().warning("Failed to save unstuck file! " + e.getMessage());
        }
    }

    private void purge() {
        if (!this.config.contains("lastPurge")) {
            this.config.set("lastPurge", (Object)System.currentTimeMillis());
        }
        long lastPurge = this.config.getLong("lastPurge", System.currentTimeMillis());
        long diff = System.currentTimeMillis() - lastPurge;
        long days = TimeUnit.MILLISECONDS.toDays(diff);
        long left = diff - TimeUnit.DAYS.toMillis(days);
        if (days >= 3L && left >= 0L) {
            this.config.set("locs", new ArrayList());
            this.config.set("lastPurge", (Object)System.currentTimeMillis());
        }
    }

    @Override
    public boolean playersOnly() {
        return true;
    }

    @Override
    @NotNull
    public String usage() {
        return "/unstuck";
    }

    @Override
    @NotNull
    public String description() {
        return "Get stuck in a hole? Teleport out";
    }

    @Override
    public void perform(final @NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You have to be a player to use that command!");
            return;
        }
        final Player player = (Player)sender;
        final UUID id = player.getUniqueId();
        if (this.cooldown.containsKey(id)) {
            long time = this.cooldown.get(id) - System.currentTimeMillis();
            if (time > 0L) {
                long seconds = TimeUnit.MILLISECONDS.toSeconds(time);
                CodexEngine.get().getMessageUtil().sendMessage("general.commands.unstuck.err.cooldown", sender, new MessageData("time", seconds));
                return;
            }
            this.cooldown.remove(id);
        }
        if (this.warmingUp.containsKey(id)) {
            CodexEngine.get().getMessageUtil().sendMessage("general.commands.unstuck.err.warmingUp", sender, new MessageData[0]);
            return;
        }
        this.warmingUp.put(id, player.getLocation().getBlock().getLocation());
        CodexEngine.get().getMessageUtil().sendMessage("general.commands.unstuck.warmup", sender, new MessageData("time", CodexEngine.get().cfg().getJYML().getLong("unstuck.warmup")));
        String locStr = this.locToString(player.getLocation());
        CodexEngine.get().getLogger().info("STUCK - " + player.getName() + " executed '/stuck' at " + locStr);
        this.purge();
        List list = this.config.getStringList("locs");
        list.add(locStr);
        this.config.set("locs", (Object)list);
        this.saveFile();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                player.teleport(UnstuckCommand.this.locs.get(player.getUniqueId()).getFirst());
                UnstuckCommand.this.tasks.remove(id);
                UnstuckCommand.this.warmingUp.remove(id);
                UnstuckCommand.this.cooldown.put(id, TimeUnit.SECONDS.toMillis(CodexEngine.get().cfg().getJYML().getLong("unstuck.cooldown")) + System.currentTimeMillis());
                CodexEngine.get().getMessageUtil().sendMessage("general.commands.unstuck.teleported", sender, new MessageData[0]);
            }
        }.runTaskLater((Plugin)CodexEngine.get(), CodexEngine.get().cfg().getJYML().getLong("unstuck.warmup") * 20L);
        this.tasks.put(id, task);
    }

    @EventHandler
    public void cancelWarmup(PlayerMoveEvent event) {
        boolean same;
        if (this.warmingUp.containsKey(event.getPlayer().getUniqueId()) && !(same = event.getPlayer().getLocation().getBlock().getLocation().equals((Object)this.warmingUp.get(event.getPlayer().getUniqueId())))) {
            BukkitTask task = this.tasks.get(event.getPlayer().getUniqueId());
            if (task != null) {
                task.cancel();
            }
            this.warmingUp.remove(event.getPlayer().getUniqueId());
            CodexEngine.get().getMessageUtil().sendMessage("general.commands.unstuck.err.cancelled", (CommandSender)event.getPlayer(), new MessageData[0]);
        }
    }

    @EventHandler
    public void move(PlayerMoveEvent event) {
        LinkedList<Location> pLocs;
        boolean notGround = event.getPlayer().getLocation().getBlock().getRelative(BlockFace.DOWN).isPassable();
        if (notGround) {
            return;
        }
        Player p = event.getPlayer();
        if (!this.locs.containsKey(p.getUniqueId())) {
            this.locs.put(p.getUniqueId(), new LinkedList());
        }
        if ((pLocs = this.locs.get(p.getUniqueId())).contains(p.getLocation().getBlock().getLocation())) {
            return;
        }
        pLocs.add(p.getLocation().getBlock().getLocation());
        if (pLocs.size() > 10) {
            pLocs.removeFirst();
        }
        this.locs.put(p.getUniqueId(), pLocs);
    }

    public String locToString(Location loc) {
        return Objects.requireNonNull(loc.getWorld()).getName() + "," + loc.getX() + "," + loc.getY() + "," + loc.getZ();
    }
}

