/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.commands;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.CommandRegister;
import studio.magemonkey.codex.commands.api.IGeneralCommand;
import studio.magemonkey.codex.commands.list.AboutCommand;
import studio.magemonkey.codex.commands.list.EditorCommand;
import studio.magemonkey.codex.commands.list.HelpCommand;
import studio.magemonkey.codex.commands.list.MainCommand;
import studio.magemonkey.codex.commands.list.ReloadCommand;
import studio.magemonkey.codex.manager.api.Loadable;

public class CommandManager<P extends CodexPlugin<P>>
implements Loadable {
    @NotNull
    private final P plugin;
    private Set<IGeneralCommand<P>> commands;
    private MainCommand<P> mainCommand;

    public CommandManager(@NotNull P plugin) {
        this.plugin = plugin;
    }

    @Override
    public void setup() {
        this.commands = new HashSet<IGeneralCommand<P>>();
        this.mainCommand = new MainCommand<P>(this.plugin);
        this.mainCommand.addDefaultCommand(new HelpCommand<P>(this.plugin));
        ((CodexPlugin)this.plugin).registerCommands(this.mainCommand);
        if (((CodexPlugin)this.plugin).hasEditor()) {
            this.mainCommand.addSubCommand(new EditorCommand<P>(this.plugin));
        }
        this.mainCommand.addSubCommand(new ReloadCommand<P>(this.plugin));
        if (!((CodexPlugin)this.plugin).isEngine()) {
            this.mainCommand.addSubCommand(new AboutCommand<P>(this.plugin));
        }
        this.registerCommand(this.mainCommand);
    }

    @Override
    public void shutdown() {
        for (IGeneralCommand<P> cmd : new HashSet<IGeneralCommand<P>>(this.commands)) {
            this.unregisterCommand(cmd);
            cmd.clearSubCommands();
            Object var2_2 = null;
        }
        this.commands.clear();
    }

    @NotNull
    public Set<IGeneralCommand<P>> getCommands() {
        return this.commands;
    }

    @NotNull
    public MainCommand<P> getMainCommand() {
        return this.mainCommand;
    }

    public void registerCommand(@NotNull IGeneralCommand<P> cmd) {
        if (this.commands.add(cmd)) {
            CommandRegister.register(this.plugin, cmd);
        }
    }

    public void unregisterCommand(@NotNull IGeneralCommand<P> cmd) {
        if (this.commands.remove(cmd)) {
            CommandRegister.unregister(this.plugin, cmd.labels());
        }
    }
}

