/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.nms.v1_21_5;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemTrident;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftChatMessage;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.Codex;
import studio.magemonkey.codex.compat.NMS;

public class NMSImpl
implements NMS {
    @Override
    public String getVersion() {
        return "1.21.5";
    }

    @Override
    @NotNull
    public Object getConnection(Player player) {
        return ((CraftPlayer)player).getHandle().f;
    }

    @Override
    @NotNull
    public Channel getChannel(@NotNull Player player) {
        PlayerConnection connection = (PlayerConnection)this.getConnection(player);
        try {
            Field networkManagerField = this.getField(connection.getClass(), "e");
            networkManagerField.setAccessible(true);
            NetworkManager networkManager = (NetworkManager)networkManagerField.get(connection);
            return networkManager.n;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Could not get Channel field from PlayerConnection", e);
        }
    }

    @Override
    public void sendPacket(@NotNull Player player, @NotNull Object packet) {
        Preconditions.checkArgument((boolean)(packet instanceof Packet), (Object)"Packet must be an instance of net.minecraft.server.Packet");
        ((PlayerConnection)this.getConnection(player)).a((Packet)packet);
    }

    @Override
    public void openChestAnimation(@NotNull Block chest, boolean open) {
        WorldServer world = ((CraftWorld)chest.getWorld()).getHandle();
        BlockPosition position = new BlockPosition(chest.getX(), chest.getY(), chest.getZ());
        IBlockData blockData = world.a_(position);
        world.a(position, blockData.b(), 1, open ? 1 : 0);
    }

    @Override
    public void sendAttackPacket(@NotNull Player player, int i) {
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation((net.minecraft.world.entity.Entity)((CraftPlayer)player).getHandle(), i);
        this.sendPacket(player, packet);
    }

    @Override
    @NotNull
    public String fixColors(@NotNull String str) {
        str = str.replace("\n", "%n%");
        IChatBaseComponent baseComponent = CraftChatMessage.fromStringOrNull((String)str);
        String singleColor = CraftChatMessage.fromComponent((IChatBaseComponent)baseComponent);
        return singleColor.replace("%n%", "\n");
    }

    @Override
    public double getDefaultDamage(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.ATTACK_DAMAGE);
    }

    @Override
    public double getDefaultSpeed(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.ATTACK_SPEED);
    }

    @Override
    public double getDefaultArmor(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.ARMOR);
    }

    @Override
    public double getDefaultToughness(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.ARMOR_TOUGHNESS);
    }

    @Override
    public boolean isWeapon(@NotNull ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Item item = nmsItem.h();
        return itemStack.getType().name().contains("SWORD") || item instanceof ItemAxe || item instanceof ItemTrident;
    }

    @Override
    public boolean isArmor(@NotNull ItemStack itemStack) {
        return itemStack.getItemMeta() instanceof ArmorMeta;
    }

    @Override
    public boolean isTool(@NotNull ItemStack itemStack) {
        Material material = itemStack.getType();
        String[] suffixes = new String[]{"_AXE", "_HOE", "_SHOVEL", "_PICKAXE", "_SHEARS"};
        return Arrays.stream(suffixes).anyMatch(suffix -> material.name().endsWith((String)suffix));
    }

    @Override
    public String toJson(@NotNull ItemStack item) {
        try {
            NBTTagCompound nbtCompound = new NBTTagCompound();
            net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.b((HolderLookup.a)CraftRegistry.getMinecraftRegistry(), (NBTBase)nbtCompound);
            String js = nbtCompound.toString();
            if (js.length() > Short.MAX_VALUE) {
                ItemStack item2 = new ItemStack(item.getType());
                return this.toJson(item2);
            }
            return js;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setKiller(@NotNull LivingEntity entity, @NotNull Player killer) {
        EntityLiving hit = ((CraftLivingEntity)entity).getHandle();
        hit.a((EntityHuman)((CraftPlayer)killer).getHandle(), 100);
    }

    @Override
    public void changeSkull(@NotNull Block block, @NotNull String hash) {
        try {
            if (!(block.getState() instanceof Skull)) {
                return;
            }
            try {
                Skull skull = (Skull)block.getState();
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)hash.substring(0, 16));
                PlayerTextures textures = profile.getTextures();
                if (hash.startsWith("http")) {
                    textures.setSkin(new URL(hash));
                } else {
                    String decoded;
                    try {
                        decoded = new String(Base64.getDecoder().decode(hash));
                    }
                    catch (IllegalArgumentException ignored) {
                        try {
                            decoded = new String(Base64.getMimeDecoder().decode(hash));
                        }
                        catch (IllegalArgumentException ignored2) {
                            decoded = new String(Base64.getUrlDecoder().decode(hash));
                        }
                    }
                    JsonObject json = (JsonObject)new Gson().fromJson(decoded, JsonObject.class);
                    JsonObject texturesJson = json.getAsJsonObject("textures");
                    JsonObject skin = texturesJson.getAsJsonObject("SKIN");
                    String url = skin.get("url").getAsString();
                    textures.setSkin(new URL(url));
                }
                profile = (PlayerProfile)profile.update().get();
                skull.setOwnerProfile(profile);
                skull.update();
            }
            catch (Exception | NoSuchMethodError e) {
                Codex.info("Could not change skull with modern method, trying legacy method.");
                if (!(block.getState() instanceof Skull)) {
                    return;
                }
                TileEntitySkull skull = (TileEntitySkull)((CraftWorld)block.getWorld()).getHandle().c_(new BlockPosition(block.getX(), block.getY(), block.getZ()));
                if (skull == null) {
                    return;
                }
                ResolvableProfile profile = new ResolvableProfile(this.getNonPlayerProfile(hash));
                skull.a(profile);
                skull.e();
            }
        }
        catch (Exception e) {
            Codex.warn("Could not update skull");
            e.printStackTrace();
        }
    }

    @Override
    public void addSkullTexture(@NotNull ItemStack item, @NotNull String value, @NotNull UUID uuid) {
        if (item.getType() != Material.PLAYER_HEAD) {
            return;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta == null) {
            return;
        }
        try {
            PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)uuid, (String)uuid.toString().substring(0, 16));
            String decoded = new String(Base64.getDecoder().decode(value));
            JsonObject json = (JsonObject)new Gson().fromJson(decoded, JsonObject.class);
            JsonObject texturesJson = json.getAsJsonObject("textures");
            JsonObject skin = texturesJson.getAsJsonObject("SKIN");
            String url = skin.get("url").getAsString();
            playerProfile.getTextures().setSkin(new URL(url));
            meta.setOwnerProfile(playerProfile);
            item.setItemMeta((ItemMeta)meta);
        }
        catch (IllegalArgumentException | NoClassDefFoundError | NoSuchMethodError | MalformedURLException e) {
            NMS.super.addSkullTexture(item, value, uuid);
        }
    }

    @Override
    @NotNull
    public Attribute getAttribute(String name) {
        return (Attribute)Registry.ATTRIBUTE.getOrThrow(NamespacedKey.minecraft((String)name.toLowerCase(Locale.US)));
    }

    @Override
    public Object getNMSCopy(@NotNull ItemStack item) {
        return CraftItemStack.asNMSCopy((ItemStack)item);
    }

    @Override
    public Material getMaterial(Boat boat) {
        String boatClassName = boat.getClass().getSimpleName().replace("Craft", "");
        String materialName = String.join((CharSequence)"_", boatClassName.split("(?=[A-Z])")).toUpperCase(Locale.US);
        Material mat = Material.matchMaterial((String)materialName);
        if (mat == null) {
            mat = Material.OAK_BOAT;
        }
        return mat;
    }

    @Override
    public Objective registerNewObjective(Scoreboard scoreboard, Objective objective) {
        return scoreboard.registerNewObjective(objective.getName(), objective.getTrackedCriteria(), objective.getDisplayName());
    }

    @Override
    public HoverEvent getHoverEvent(@NotNull ItemStack itemStack) {
        String nbt = String.format("{\"id\":\"%s\",\"count\":%d,\"components\": %s}", itemStack.getType().getKey().getKey(), itemStack.getAmount(), itemStack.getItemMeta() != null ? itemStack.getItemMeta().getAsString() : "{}");
        return new HoverEvent(HoverEvent.Action.SHOW_ITEM, new BaseComponent[]{new TextComponent(nbt)});
    }

    @Override
    public BaseComponent getTranslatedComponent(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        String string = null;
        if (meta != null && (string = meta.getDisplayName()).isEmpty()) {
            try {
                string = meta.getItemName();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        Object baseComponent = string == null || string.isEmpty() ? new TranslatableComponent(itemStack.getType().getItemTranslationKey(), new Object[0]) : new TextComponent(string);
        return baseComponent;
    }

    @Override
    public EntityDamageByEntityEvent createEntityDamageEvent(@NotNull Entity entity, @NotNull Entity attacker, @NotNull EntityDamageEvent.DamageCause cause, double damage) {
        return new EntityDamageByEntityEvent(attacker, entity, cause, DamageSource.builder((DamageType)DamageType.MOB_ATTACK).build(), damage);
    }
}

