/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.sql.direct;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import studio.magemonkey.codex.mccore.sql.direct.ISQLEntryData;
import studio.magemonkey.codex.mccore.sql.direct.SQLDatabase;
import studio.magemonkey.codex.mccore.sql.direct.SQLTable;

public class SQLEntry {
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final char SQUOTE = '`';
    private SQLDatabase database;
    private final SQLTable table;
    private final String name;

    public SQLEntry(SQLDatabase database, SQLTable table, String name) {
        this.database = database;
        this.table = table;
        this.name = name;
    }

    public <T extends ISQLEntryData> T getData(T container) {
        try {
            ResultSet set = this.table.query(this.name);
            if (set.next()) {
                container.loadData(set);
            }
            set.close();
            return container;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getString(String key) {
        try {
            ResultSet set = this.table.query(this.name);
            set.next();
            String value = set.getString(key);
            set.close();
            if (value != null) {
                return value.replace('`', '\'').replace('\u221a', '\'');
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int getInt(String key) {
        try {
            ResultSet set = this.table.query(this.name);
            set.next();
            int value = set.getInt(key);
            set.close();
            return value;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public float getFloat(String key) {
        try {
            ResultSet set = this.table.query(this.name);
            set.next();
            float value = set.getFloat(key);
            set.close();
            return value;
        }
        catch (Exception ex) {
            return -1.0f;
        }
    }

    public double getDouble(String key) {
        try {
            ResultSet set = this.table.query(this.name);
            set.next();
            double value = set.getDouble(key);
            set.close();
            return value;
        }
        catch (Exception ex) {
            return -1.0;
        }
    }

    public Date getDate(String key) {
        try {
            ResultSet set = this.table.query(this.name);
            set.next();
            java.sql.Date value = set.getDate(key);
            set.close();
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void set(String key, String value) {
        try {
            PreparedStatement statement = this.database.getStatement("UPDATE " + this.table.getName() + " SET " + key + "=? WHERE Name=?");
            statement.setString(1, value);
            statement.setString(2, this.name);
            statement.execute();
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to set the value \"" + key + "\" for \"" + this.name + "\" - " + ex.getMessage());
        }
    }

    public void set(String key, int value) {
        try {
            this.database.getStatement().execute("UPDATE " + this.table.getName() + " SET " + key + "=" + value + " WHERE Name='" + this.name + "'");
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to set the value \"" + key + "\" for \"" + this.name + "\" - " + ex.getMessage());
        }
    }

    public void set(String key, double value) {
        try {
            this.database.getStatement().execute("UPDATE " + this.table.getName() + " SET " + key + "=" + value + " WHERE Name='" + this.name + "'");
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to set the value \"" + key + "\" for \"" + this.name + "\" - " + ex.getMessage());
        }
    }

    public void set(String key, float value) {
        try {
            this.database.getStatement().execute("UPDATE " + this.table.getName() + " SET " + key + "=" + value + " WHERE Name='" + this.name + "'");
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to set the value \"" + key + "\" for \"" + this.name + "\" - " + ex.getMessage());
        }
    }

    public void set(String key, Date value) {
        try {
            this.database.getStatement().execute("UPDATE " + this.table.getName() + " SET " + key + "='" + FORMAT.format(value) + "' WHERE Name='" + this.name + "'");
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to set the value \"" + key + "\" for \"" + this.name + "\" - " + ex.getMessage());
        }
    }

    public void set(HashMap<String, Object> data) {
        StringBuilder sb = new StringBuilder("UPDATE " + this.table.getName() + " SET ");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            sb.append(entry.getKey());
            sb.append('=');
            boolean num = entry.getValue() instanceof Number;
            if (!num) {
                sb.append('\'');
            }
            if (entry.getValue() instanceof Date) {
                sb.append(FORMAT.format((Date)entry.getValue()));
            } else {
                sb.append(entry.getValue());
            }
            if (!num) {
                sb.append('\'');
            }
            sb.append(" WHERE Name='");
            sb.append(this.name);
            sb.append('\'');
        }
        try {
            this.database.getStatement().execute(sb.toString());
        }
        catch (Exception ex) {
            this.database.getLogger().severe("Failed to set the map of values for \"" + this.name + "\" - " + ex.getMessage());
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

