/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.gui;

import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.mccore.gui.MapData;
import studio.magemonkey.codex.mccore.gui.MapMenu;
import studio.magemonkey.codex.mccore.gui.MapMenuManager;

public class MapListener
implements Listener {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final Vector ZERO = new Vector(0, 0, 0);
    long last = 0L;

    public MapListener(CodexEngine core) {
        core.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)core);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        MapData data = MapMenuManager.getActiveMenuData(event.getPlayer());
        if (data == null) {
            return;
        }
        Vector moving = event.getTo().clone().subtract(event.getFrom()).toVector();
        moving.setY(0);
        if (moving.lengthSquared() < 1.0E-8) {
            return;
        }
        Location loc = new Location(event.getFrom().getWorld(), event.getFrom().getX(), event.getTo().getY(), event.getFrom().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
        event.getPlayer().teleport(loc);
        moving.normalize();
        if (System.currentTimeMillis() - this.last < 300L) {
            this.last = System.currentTimeMillis();
            return;
        }
        this.last = System.currentTimeMillis();
        MapMenu menu = data.getMenu(event.getPlayer());
        Vector facing = event.getTo().getDirection();
        facing.setY(0);
        facing.normalize();
        double dot = moving.dot(facing);
        if (dot > 0.5) {
            menu.onUp(event.getPlayer());
        } else if (dot < -0.5) {
            menu.onDown(event.getPlayer());
        } else {
            facing.crossProduct(UP);
            dot = moving.dot(facing);
            if (dot > 0.0) {
                menu.onRight(event.getPlayer());
            } else {
                menu.onLeft(event.getPlayer());
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        MapData data = MapMenuManager.getActiveMenuData(event.getPlayer());
        if (data == null) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            event.setCancelled(true);
            data.getMenu(event.getPlayer()).onSelect(event.getPlayer());
        }
    }

    @EventHandler
    public void onInteract(PlayerToggleSneakEvent event) {
        MapData data = MapMenuManager.getActiveMenuData(event.getPlayer());
        if (data == null) {
            return;
        }
        if (event.isSneaking()) {
            data.getMenu(event.getPlayer()).onBack(event.getPlayer());
            data.back(event.getPlayer());
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        MapData data = MapMenuManager.getActiveMenuData(event.getPlayer());
        if (data != null) {
            MapMenu menu = data.getMenu(event.getPlayer());
            menu.onExit(event.getPlayer());
            data.clear(event.getPlayer());
        }
    }
}

