/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.config;

import java.io.File;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.mccore.config.parse.JSONParser;

public class DataFile {
    private final String fileName;
    private final JavaPlugin plugin;
    private File configFile;
    private DataSection data;

    public DataFile(JavaPlugin plugin, String name) {
        this.plugin = plugin;
        this.fileName = name + ".json";
        this.configFile = new File(plugin.getDataFolder().getAbsolutePath() + "/" + this.fileName);
        try {
            String path = this.configFile.getAbsolutePath();
            if (new File(path.substring(0, path.lastIndexOf(File.separator))).mkdirs()) {
                plugin.getLogger().info("Created a new folder for data files");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public String getFileName() {
        return this.fileName.replace(".json", "");
    }

    public void clear() {
        if (this.data == null) {
            this.reload();
        }
        this.data.clear();
    }

    public void reload() {
        this.data = JSONParser.parseFile(this.configFile);
    }

    public DataSection getData() {
        if (this.data == null) {
            this.reload();
        }
        return this.data;
    }

    public File getFile() {
        return this.configFile;
    }

    public void save() {
        if (this.data != null && this.configFile != null) {
            try {
                this.data.dump(this.configFile);
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save data to " + String.valueOf(this.configFile), ex);
            }
        }
    }
}

