/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.item;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.legacy.item.DataBuilder;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;

@SerializableAs(value="Codex_PotionMeta")
public class PotionDataBuilder
extends DataBuilder {
    protected Map<PotionEffectType, PotionData> potions = new LinkedHashMap<PotionEffectType, PotionData>(5);
    protected PotionEffectType main = PotionEffectType.SPEED;

    public PotionDataBuilder(Map<String, Object> map) {
        DeserializationWorker w = DeserializationWorker.start(map);
        this.main = PotionEffectType.getByName((String)w.getString("main", "SPEED"));
        Map effects = (Map)w.getTypedObject("effects");
        for (Map.Entry entry : effects.entrySet()) {
            PotionEffectType type = PotionEffectType.getByName((String)entry.getKey().toString());
            DeserializationWorker effect = DeserializationWorker.startUnsafe((Map)entry.getValue());
            byte power = effect.getByte("power");
            int time = effect.getInt("time");
            boolean ambient = effect.getBoolean("ambient");
            this.potions.put(type, new PotionData(power, time, ambient));
        }
    }

    public PotionDataBuilder potions(Map<PotionEffectType, PotionData> potions) {
        this.potions = potions;
        return this;
    }

    public PotionDataBuilder add(PotionEffectType type, byte power, int time, boolean ambient) {
        this.potions.put(type, new PotionData(power, time, ambient));
        return this;
    }

    public PotionDataBuilder add(PotionEffectType type, int power, int time, boolean ambient) {
        return this.add(type, (byte)power, time, ambient);
    }

    public PotionDataBuilder add(PotionEffectType type, byte power, int time) {
        return this.add(type, power, time, false);
    }

    public PotionDataBuilder add(PotionEffectType type, int power, int time) {
        return this.add(type, (byte)power, time);
    }

    public PotionDataBuilder add(PotionEffectType type, byte power) {
        return this.add(type, power, 0);
    }

    public PotionDataBuilder add(PotionEffectType type, int time) {
        return this.add(type, 0, time);
    }

    public PotionDataBuilder remove(PotionEffectType type) {
        this.potions.remove(type);
        return this;
    }

    public PotionDataBuilder clear() {
        this.potions.clear();
        return this;
    }

    public PotionDataBuilder main(PotionEffectType type) {
        this.main = type;
        return this;
    }

    @Override
    public void apply(ItemMeta itemMeta) {
        if (!(itemMeta instanceof PotionMeta)) {
            return;
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        meta.clearCustomEffects();
        for (Map.Entry<PotionEffectType, PotionData> entry : this.potions.entrySet()) {
            PotionData data = entry.getValue();
            meta.addCustomEffect(new PotionEffect(entry.getKey(), data.time, (int)data.power, data.ambient), true);
        }
        if (this.main != null) {
            meta.setMainEffect(this.main);
        }
    }

    @Override
    public PotionDataBuilder use(ItemMeta itemMeta) {
        if (!(itemMeta instanceof PotionMeta)) {
            return null;
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        if (meta.hasCustomEffects()) {
            this.main = ((PotionEffect)meta.getCustomEffects().get(0)).getType();
        }
        for (PotionEffect effect : meta.getCustomEffects()) {
            this.potions.put(effect.getType(), new PotionData((byte)effect.getAmplifier(), effect.getDuration(), effect.isAmbient()));
        }
        return this;
    }

    @Override
    public String getType() {
        return "potion";
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        SerializationBuilder b = SerializationBuilder.start(3).append(super.serialize());
        b.append("main", (Object)this.main.getName());
        SerializationBuilder effects = SerializationBuilder.start(this.potions.size());
        for (Map.Entry<PotionEffectType, PotionData> entry : this.potions.entrySet()) {
            SerializationBuilder effect = SerializationBuilder.start(3);
            PotionData potionData = entry.getValue();
            effect.append("power", (Object)potionData.power);
            effect.append("time", (Object)potionData.time);
            effect.append("ambient", (Object)potionData.ambient);
            effects.append(entry.getKey().getName(), effect);
        }
        b.append("effects", effects);
        return b.build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("potions", this.potions).append("main", (Object)this.main).toString();
    }

    public static PotionDataBuilder start() {
        return new PotionDataBuilder();
    }

    @Generated
    public Map<PotionEffectType, PotionData> getPotions() {
        return this.potions;
    }

    @Generated
    public PotionEffectType getMain() {
        return this.main;
    }

    @Generated
    public PotionDataBuilder() {
    }

    public class PotionData {
        private final byte power;
        private final int time;
        private final boolean ambient;

        public PotionData(byte power, int time, boolean ambient) {
            this.power = power;
            this.time = time;
            this.ambient = ambient;
        }

        public byte getPower() {
            return this.power;
        }

        public int getTime() {
            return this.time;
        }

        public boolean isAmbient() {
            return this.ambient;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("power", this.power).append("time", this.time).append("ambient", this.ambient).toString();
        }
    }
}

