/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.config.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.config.api.ILangTemplate;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.codex.util.MsgUT;
import studio.magemonkey.codex.util.StringUT;

public class ILangMsg {
    private static final Pattern PATTERN_MESSAGE = Pattern.compile("(\\{message:)+(.)+?(\\})+(.*?)(\\})?");
    private static final String[] MESSAGE_ARGUMENTS = new String[]{"type", "prefix", "fadeIn", "stay", "fadeOut"};
    private static final Pattern[] PATTERN_ARGUMENTS = new Pattern[MESSAGE_ARGUMENTS.length];
    private ILangTemplate template;
    private String msgDefault;
    private String msgColor;
    private String path;
    private OutputType out = OutputType.CHAT;
    private boolean isPrefix = true;
    private int[] titlesTimes = new int[3];

    public ILangMsg(@NotNull ILangTemplate template, @NotNull String msg) {
        this.template = template;
        this.msgDefault = msg;
        this.setMsg(msg);
    }

    ILangMsg(@NotNull ILangMsg from) {
        this.template = from.template;
        this.msgDefault = from.getDefaultMsg();
        this.msgColor = from.getMsg();
        this.path = from.getPath();
        this.out = from.out;
        this.isPrefix = from.isPrefix;
        this.titlesTimes = from.titlesTimes;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    void setPath(@NotNull String path) {
        this.path = path.replace("_", ".");
    }

    boolean setArguments(@NotNull String msg) {
        Matcher mArgs = PATTERN_MESSAGE.matcher(msg);
        if (!mArgs.find()) {
            return false;
        }
        String extract = mArgs.group(0);
        String arguments = extract.replace("{message:", "").replace("}", "").trim();
        this.msgColor = msg.replace(extract, "");
        block14: for (int i = 0; i < MESSAGE_ARGUMENTS.length; ++i) {
            String argType = MESSAGE_ARGUMENTS[i];
            Pattern pArgVal = PATTERN_ARGUMENTS[i];
            Matcher mArgVal = pArgVal.matcher(arguments);
            if (!mArgVal.find()) continue;
            String argValue = mArgVal.group(4).trim();
            switch (argType) {
                case "type": {
                    this.out = CollectionsUT.getEnum(argValue, OutputType.class);
                    continue block14;
                }
                case "prefix": {
                    this.isPrefix = Boolean.parseBoolean(argValue);
                    continue block14;
                }
                case "fadeIn": {
                    this.titlesTimes[0] = StringUT.getInteger(argValue, -1);
                    continue block14;
                }
                case "stay": {
                    this.titlesTimes[1] = StringUT.getInteger(argValue, -1);
                    if (this.titlesTimes[1] >= 0) continue block14;
                    this.titlesTimes[1] = 10000;
                    continue block14;
                }
                case "fadeOut": {
                    this.titlesTimes[2] = StringUT.getInteger(argValue, -1);
                }
            }
        }
        return true;
    }

    @NotNull
    public String getDefaultMsg() {
        return this.msgDefault;
    }

    @NotNull
    public String getMsgReady() {
        return (String)this.replaceDefaults().apply(this.msgColor);
    }

    @NotNull
    public String getMsg() {
        return this.msgColor;
    }

    public void setMsg(@NotNull String msg) {
        if (!this.setArguments(msg)) {
            this.msgColor = msg;
        }
        if (!MsgUT.isJSON(msg)) {
            this.msgColor = StringUT.color(this.msgColor);
        }
    }

    @NotNull
    public ILangMsg replace(@NotNull String var, @NotNull Object r) {
        if (this.isEmpty()) {
            return this;
        }
        if (r instanceof List) {
            return this.replace(var, (List)r);
        }
        return this.replace(str -> str.replace(var, String.valueOf(r)));
    }

    @NotNull
    public ILangMsg replace(@NotNull String var, @NotNull List<Object> r) {
        if (this.isEmpty()) {
            return this;
        }
        StringBuilder builder = new StringBuilder();
        r.forEach(rep -> {
            if (builder.length() > 0) {
                builder.append("\\n");
            }
            builder.append(rep.toString());
        });
        return this.replace(str -> str.replace(var, builder.toString()));
    }

    @NotNull
    public ILangMsg replace(@NotNull UnaryOperator<String> r) {
        if (this.isEmpty()) {
            return this;
        }
        ILangMsg msgCopy = new ILangMsg(this);
        msgCopy.msgColor = StringUT.color((String)r.apply(msgCopy.getMsg()));
        return msgCopy;
    }

    public boolean isEmpty() {
        return this.out == OutputType.NONE || this.getMsg().isEmpty();
    }

    public void broadcast() {
        if (this.isEmpty()) {
            return;
        }
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (player == null) continue;
            this.send((CommandSender)player);
        }
        this.send((CommandSender)Bukkit.getServer().getConsoleSender());
    }

    public void send(@NotNull CommandSender sender) {
        if (this.isEmpty()) {
            return;
        }
        if (this.out == OutputType.CHAT) {
            String prefix = this.isPrefix ? this.template.plugin.lang().Prefix.getMsgReady() : "";
            this.asList().forEach(line -> MsgUT.sendWithJSON(sender, prefix + line));
        } else if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.out == OutputType.ACTION_BAR) {
                MsgUT.sendActionBar(player, this.getMsgReady());
            } else if (this.out == OutputType.TITLES) {
                List<String> list = this.asList();
                if (list.isEmpty()) {
                    return;
                }
                String title = list.get(0);
                String subtitle = list.size() > 1 ? list.get(1) : "";
                player.sendTitle(title, subtitle, this.titlesTimes[0], this.titlesTimes[1], this.titlesTimes[2]);
            }
        }
    }

    @NotNull
    public List<String> asList() {
        String msg = this.getMsgReady();
        if (msg.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String line : msg.split("\\\\n")) {
            list.add(line.trim());
        }
        return list;
    }

    @NotNull
    public String normalizeLines() {
        StringBuilder text = new StringBuilder("");
        for (String line : this.asList()) {
            if (text.length() > 0) {
                text.append("\n");
            }
            text.append(line);
        }
        return text.toString();
    }

    @NotNull
    private UnaryOperator<String> replaceDefaults() {
        return str -> {
            for (Map.Entry<String, String> entry : this.template.getCustomPlaceholders().entrySet()) {
                str = str.replace(entry.getKey(), entry.getValue());
            }
            return str.replace("%plugin%", this.template.plugin.cfg().pluginName);
        };
    }

    static {
        for (int i = 0; i < MESSAGE_ARGUMENTS.length; ++i) {
            ILangMsg.PATTERN_ARGUMENTS[i] = Pattern.compile("(~)+(" + MESSAGE_ARGUMENTS[i] + ")+?(:)+(.*?)(;)");
        }
    }

    public static enum OutputType {
        CHAT,
        ACTION_BAR,
        TITLES,
        NONE;

    }
}

