/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.commands;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.IGeneralCommand;
import studio.magemonkey.codex.util.Reflex;

public class CommandRegister
extends Command
implements PluginIdentifiableCommand {
    protected final CommandExecutor owner;
    protected Plugin plugin;
    protected TabCompleter tab;

    public CommandRegister(String[] aliases, String desc, String usage, CommandExecutor owner, Plugin plugin2) {
        super(aliases[0], desc, usage, Arrays.asList(aliases));
        this.owner = owner;
        this.plugin = plugin2;
    }

    public void setTabCompleter(@NotNull TabCompleter tab) {
        this.tab = tab;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        return this.owner.onCommand(sender, (Command)this, label, args);
    }

    @NotNull
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        List list;
        if (this.tab != null && (list = this.tab.onTabComplete(sender, (Command)this, alias, args)) != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static void register(@NotNull Plugin plugin, @NotNull IGeneralCommand<?> command) {
        CommandRegister cmd = new CommandRegister(command.labels(), command.description(), command.usage(), command, plugin);
        cmd.setTabCompleter((TabCompleter)command);
        cmd.setPermission(command.getPermission());
        Server server = plugin.getServer();
        CommandMap map = (CommandMap)Reflex.getFieldValue(server, "commandMap");
        if (map == null) {
            return;
        }
        map.register(plugin.getDescription().getName(), (Command)cmd);
    }

    public static void register(Plugin plugin, CommandExecutor cxecutor, TabCompleter tab, String[] aliases, String desc, String usage) {
        CommandRegister reg = new CommandRegister(aliases, desc, usage, cxecutor, plugin);
        reg.setTabCompleter(tab);
        Server server = plugin.getServer();
        CommandMap map = (CommandMap)Reflex.getFieldValue(server, "commandMap");
        if (map == null) {
            return;
        }
        map.register(plugin.getDescription().getName(), (Command)reg);
    }

    public static void syncCommands() {
        Server server = Bukkit.getServer();
        Method method = Reflex.getMethod(server.getClass(), "syncCommands", new Class[0]);
        if (method == null) {
            return;
        }
        Reflex.invokeMethod(method, server, new Object[0]);
    }

    public static void unregister(@NotNull CodexPlugin<?> plugin, String[] aliases) {
        SimpleCommandMap map = (SimpleCommandMap)Reflex.getFieldValue(plugin.getPluginManager(), "commandMap");
        if (map == null) {
            return;
        }
        HashMap knownCommands = (HashMap)Reflex.getFieldValue(map, "knownCommands");
        if (knownCommands == null) {
            return;
        }
        for (String command : aliases) {
            for (String commandAlias : CommandRegister.getAliases(command)) {
                Command cmd = map.getCommand(commandAlias);
                if (cmd == null) continue;
                if (!cmd.unregister((CommandMap)map)) {
                    plugin.error("Unable to unregister command: " + commandAlias);
                }
                knownCommands.remove(commandAlias);
            }
        }
    }

    @NotNull
    public static Set<String> getAliases(@NotNull String cmd) {
        SimpleCommandMap map = (SimpleCommandMap)Reflex.getFieldValue(Bukkit.getServer().getPluginManager(), "commandMap");
        if (map == null) {
            return Collections.emptySet();
        }
        for (Command c2 : map.getCommands()) {
            if (!c2.getLabel().equalsIgnoreCase(cmd) && !c2.getAliases().contains(cmd)) continue;
            HashSet<String> aa = new HashSet<String>(c2.getAliases());
            aa.add(c2.getLabel());
            return aa;
        }
        return Collections.emptySet();
    }
}

