/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.Codex;
import studio.magemonkey.codex.bungee.BungeeUtil;
import studio.magemonkey.codex.util.messages.MessageData;

public abstract class AbstractMessageUtil {
    protected Map<String, Object> messages = new HashMap<String, Object>();

    public abstract BaseComponent[] getMessageAsComponent(String var1, MessageData ... var2);

    public abstract String getMessageAsString(String var1, String var2, boolean var3, MessageData ... var4);

    public void reload(FileConfiguration config, JavaPlugin plugin) {
        Map<String, Object> temp = this.getMessages((ConfigurationSection)config);
        for (String s : temp.keySet()) {
            this.messages.remove(s);
        }
        this.messages.putAll(temp);
        Codex.info("Mapped all language data for " + plugin.getName() + ".");
    }

    public void load(FileConfiguration config, JavaPlugin plugin) {
        this.reload(config, plugin);
    }

    private Map<String, Object> getMessages(@NotNull ConfigurationSection section) {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        for (String entry : section.getValues(false).keySet()) {
            String id;
            String string = id = section.getCurrentPath().trim().isEmpty() ? entry : section.getCurrentPath() + "." + entry;
            if (section.get(entry) instanceof ConfigurationSection) {
                temp.putAll(this.getMessages((ConfigurationSection)section.get(entry)));
                continue;
            }
            if (section.get(entry) instanceof ArrayList) {
                temp.put(id, section.get(entry));
                continue;
            }
            if (section.get(entry).toString().contains("\n")) {
                ArrayList<String> array = new ArrayList<String>(Arrays.asList(section.get(entry).toString().split("\n")));
                temp.put(id, array);
                continue;
            }
            temp.put(id, section.get(entry).toString());
        }
        return temp;
    }

    public String getMessageAsString(String path, String def, MessageData ... data) {
        return this.getMessageAsString(path, def, false, data);
    }

    public void sendMessage(CommandSender player, BaseComponent ... comps) {
        ArrayList<BaseComponent> send = new ArrayList<BaseComponent>();
        for (BaseComponent component : comps) {
            if (component instanceof TextComponent && ((TextComponent)component).getText().equalsIgnoreCase("\n")) {
                player.spigot().sendMessage(send.toArray(new BaseComponent[0]));
                send.clear();
                continue;
            }
            send.add(component);
        }
        if (!send.isEmpty()) {
            player.spigot().sendMessage(send.toArray(new BaseComponent[0]));
        }
    }

    public void sendMessage(String key, CommandSender player, MessageData ... replace) {
        BaseComponent[] comps = this.getMessageAsComponent(key, replace);
        this.sendMessage(player, comps);
    }

    public void broadcastMessage(String key, MessageData ... data) {
        Bukkit.getServer().getOnlinePlayers().forEach(online -> this.sendMessage(key, (CommandSender)online, data));
        this.sendMessage(key, (CommandSender)Bukkit.getConsoleSender(), data);
    }

    public void broadcastNetworkMessage(String key, MessageData ... data) {
        if (!BungeeUtil.isBungee()) {
            this.broadcastMessage(key, data);
        } else {
            BungeeUtil.broadcastMessage(this.getMessageAsString(key, key, false, data));
        }
    }
}

