/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderRegistry;
import studio.magemonkey.codex.legacy.placeholder.PlaceholderType;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.codex.util.messages.MessageData;

public class ItemUtils {
    public static final PlaceholderType<ItemType> ITEM_TYPE = PlaceholderType.create("itemType", ItemType.class, new PlaceholderType[0]);

    public static ItemStack replaceText(ItemStack item, MessageData ... replace) {
        if (item == null) {
            return null;
        }
        ItemMeta im = ItemUtils.getItemMeta(item = item.clone());
        if (im == null) {
            return item;
        }
        if (im.hasDisplayName()) {
            im.setDisplayName(CodexEngine.get().getMessageUtil().getMessageAsString(im.getDisplayName(), im.getDisplayName(), false, replace));
        }
        if (im.getLore() != null && !im.getLore().isEmpty()) {
            List newLore = im.getLore().stream().map(lore -> CodexEngine.get().getMessageUtil().getMessageAsString((String)lore, (String)lore, false, replace)).collect(Collectors.toList());
            im.setLore(newLore);
        }
        item.setItemMeta(im);
        return item;
    }

    public static Material getMaterial(String mat) {
        Material material = Material.getMaterial((String)mat);
        if (material != null) {
            return material;
        }
        material = Material.matchMaterial((String)mat);
        if (material != null) {
            return material;
        }
        try {
            int id = Integer.parseInt(mat);
            Bukkit.getLogger().severe("Codex attempting to get a material by it's id. Please change it to a name. ID: " + mat);
            Thread.dumpStack();
            for (Material m : (Material[])Material.class.getEnumConstants()) {
                if (m.getId() != id) continue;
                return m;
            }
        }
        catch (Exception ignored) {
            return Material.AIR;
        }
        return null;
    }

    @Nullable
    public static ItemMeta getItemMeta(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return Bukkit.getItemFactory().getItemMeta(itemStack.getType());
        }
        return meta;
    }

    public static FireworkEffect simpleDeserializeEffect(Map<Object, Object> map) {
        if (map == null) {
            return null;
        }
        DeserializationWorker w = DeserializationWorker.startUnsafe(map);
        FireworkEffect.Type type = w.getEnum("type", FireworkEffect.Type.BALL);
        boolean trail = w.getBoolean("trail");
        boolean flicker = w.getBoolean("flicker");
        List<Color> colors = ItemUtils.simpleDeserializeColors((Collection)w.getTypedObject("colors"));
        List<Color> fadeColors = ItemUtils.simpleDeserializeColors((Collection)w.getTypedObject("fadeColors"));
        return FireworkEffect.builder().with(type).trail(trail).flicker(flicker).withColor(colors).withFade(fadeColors).build();
    }

    public static List<FireworkEffect> simpleDeserializeEffects(Collection<Map<Object, Object>> list) {
        if (list == null) {
            return new ArrayList<FireworkEffect>(1);
        }
        ArrayList<FireworkEffect> result = new ArrayList<FireworkEffect>(list.size());
        for (Map<Object, Object> map : list) {
            result.add(ItemUtils.simpleDeserializeEffect(map));
        }
        return result;
    }

    public static Color simpleDeserializeColor(String string) {
        if (string == null) {
            return null;
        }
        return Color.fromRGB((int)Integer.parseInt(string, 16));
    }

    public static List<Color> simpleDeserializeColors(Collection<String> strings) {
        if (strings == null) {
            return new ArrayList<Color>(1);
        }
        ArrayList<Color> result = new ArrayList<Color>(strings.size());
        for (String str : strings) {
            result.add(ItemUtils.simpleDeserializeColor(str));
        }
        return result;
    }

    public static String simpleSerializeColor(Color color) {
        if (color == null) {
            return null;
        }
        return Integer.toString(color.asRGB(), 16);
    }

    public static List<String> simpleSerializeColors(Collection<Color> colors) {
        if (colors == null) {
            return new ArrayList<String>(1);
        }
        ArrayList<String> result = new ArrayList<String>(colors.size());
        for (Color color : colors) {
            result.add(ItemUtils.simpleSerializeColor(color));
        }
        return result;
    }

    public static Map<String, Object> simpleSerializeEffect(FireworkEffect effect) {
        if (effect == null) {
            return null;
        }
        SerializationBuilder b = SerializationBuilder.start(5);
        b.append("type", (Enum<?>)effect.getType());
        b.append("trail", (Object)effect.hasTrail());
        b.append("flicker", (Object)effect.hasFlicker());
        b.append("colors", ItemUtils.simpleSerializeColors(effect.getColors()));
        b.append("fadeColors", ItemUtils.simpleSerializeColors(effect.getFadeColors()));
        return b.build();
    }

    public static List<Map<String, Object>> simpleSerializeEffects(Collection<FireworkEffect> effects) {
        if (effects == null) {
            return new ArrayList<Map<String, Object>>(1);
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(effects.size());
        for (FireworkEffect effect : effects) {
            result.add(ItemUtils.simpleSerializeEffect(effect));
        }
        return result;
    }

    public static ItemStack[] compact(boolean respectStackSize, ItemStack ... itemsToCompact) {
        ItemStack[] items = new ItemStack[itemsToCompact.length];
        int j = 0;
        for (ItemStack itemStack : itemsToCompact) {
            items[j++] = itemStack == null ? null : itemStack.clone();
        }
        int itemsLength = items.length;
        for (int i = 0; i < itemsLength; ++i) {
            ItemStack item = items[i];
            if (item == null || item.getType() == Material.AIR) continue;
            for (int k = i + 1; k < itemsLength; ++k) {
                ItemStack item2 = items[k];
                if (!item.isSimilar(item2)) continue;
                if (!respectStackSize) {
                    item.setAmount(item.getAmount() + item2.getAmount());
                    items[k] = null;
                    continue;
                }
                int space = item.getMaxStackSize() - item.getAmount();
                if (space <= 0) continue;
                int toAdd = item2.getAmount();
                if (space > toAdd) {
                    item.setAmount(item.getAmount() + toAdd);
                    items[k] = null;
                    continue;
                }
                item.setAmount(item.getAmount() + space);
                item2.setAmount(toAdd - space);
            }
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(items.length);
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            result.add(item);
        }
        return result.toArray(new ItemStack[0]);
    }

    static {
        ITEM_TYPE.registerItem("name", item -> {
            ItemStack itemStack = item.create();
            BaseComponent baseComponent = VersionManager.getNms().getTranslatedComponent(itemStack);
            baseComponent.setHoverEvent(VersionManager.getNms().getHoverEvent(itemStack));
            return baseComponent;
        });
        ITEM_TYPE.registerItem("displayName", item -> {
            ItemStack itemStack = item.create();
            BaseComponent baseComponent = VersionManager.getNms().getTranslatedComponent(itemStack);
            baseComponent.setHoverEvent(VersionManager.getNms().getHoverEvent(itemStack));
            return baseComponent;
        });
        ITEM_TYPE.registerItem("material", d -> d.create().getType());
        ITEM_TYPE.registerItem("id", item -> {
            TextComponent textComponent = new TextComponent(item.getNamespacedID());
            textComponent.setHoverEvent(VersionManager.getNms().getHoverEvent(item.create()));
            return textComponent;
        });
        ITEM_TYPE.registerItem("lore", c -> StringUtils.join((Iterable)c.create().getItemMeta().getLore(), (char)'\n'));
        ITEM_TYPE.registerItem("enchantments", c -> StringUtils.join(c.create().getEnchantments().keySet(), (String)", "));
        ITEM_TYPE.registerChild("item", PlaceholderRegistry.ITEM, ItemType::create);
    }
}

