/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.gui;

import java.util.ArrayList;
import java.util.HashMap;
import studio.magemonkey.codex.mccore.gui.MapBuffer;
import studio.magemonkey.codex.mccore.gui.MapObject;

public class MapScene {
    private HashMap<String, MapObject> items = new HashMap();
    private ArrayList<MapObject> ordered = new ArrayList();

    public void add(String key, MapObject obj) {
        this.items.put(key, obj);
        this.ordered.add(obj);
    }

    public MapObject get(String key) {
        return this.items.get(key);
    }

    public void clear() {
        this.items.clear();
    }

    public void apply(MapBuffer buffer) {
        if (this.items.size() == 0) {
            return;
        }
        int[] bounds = buffer.bounds;
        bounds[1] = 127;
        bounds[0] = 127;
        bounds[3] = 0;
        bounds[2] = 0;
        buffer.dirty = false;
        for (MapObject obj : this.ordered) {
            if (obj.isDirty()) {
                int[] dirty = obj.getFlagBounds();
                bounds[0] = Math.min(bounds[0], dirty[0]);
                bounds[1] = Math.min(bounds[1], dirty[1]);
                bounds[2] = Math.max(bounds[2], dirty[2]);
                bounds[3] = Math.max(bounds[3], dirty[3]);
                buffer.dirty = true;
            }
            obj.clean();
        }
        if (buffer.dirty) {
            buffer.clear();
            for (MapObject obj : this.ordered) {
                if (!obj.visible) continue;
                buffer.drawImg(obj.img, obj.x, obj.y + obj.img.offset);
            }
        }
    }
}

