/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.gui;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class MapFont {
    private final HashMap<Character, MapChar> chars = new HashMap();
    private Font font;
    private int space;

    public MapFont(Font font, int space) {
        this.font = font;
        this.space = space;
    }

    public Font getFont() {
        return this.font;
    }

    public int getSpace() {
        return this.space;
    }

    public int[] measureString(String str) {
        int minY = 999;
        int maxY = 0;
        int width = 0;
        for (int i = 0; i < str.length(); ++i) {
            MapChar c = this.getChar(str.charAt(i));
            minY = Math.min(minY, c.getBase());
            maxY = Math.max(maxY, c.getBase() + c.getHeight());
            width += c.getWidth() + this.getSpace();
        }
        return new int[]{width, maxY - minY, minY};
    }

    public MapChar getChar(char c) {
        if (!this.font.canDisplay(c)) {
            return null;
        }
        if (!this.chars.containsKey(Character.valueOf(c))) {
            if (c == '.') {
                this.chars.put(Character.valueOf(c), new MapChar(new boolean[]{true}, 1, 1, 0));
            } else {
                BufferedImage buffer = new BufferedImage(32, 32, 2);
                Graphics2D g = buffer.createGraphics();
                g.setFont(this.font);
                Rectangle bounds = this.font.createGlyphVector(g.getFontRenderContext(), "" + c).getPixelBounds(g.getFontRenderContext(), 0.0f, 0.0f);
                if (((RectangularShape)bounds).getWidth() <= 0.0 || ((RectangularShape)bounds).getHeight() <= 0.0 || ((RectangularShape)bounds).getWidth() > 32.0 || ((RectangularShape)bounds).getHeight() > 32.0) {
                    this.chars.put(Character.valueOf(c), new MapChar(new boolean[]{false}, 1, 1, 0));
                } else {
                    g.drawString("" + c, 0, -((int)((RectangularShape)bounds).getY()));
                    boolean[] data = new boolean[(int)(((RectangularShape)bounds).getWidth() * ((RectangularShape)bounds).getHeight())];
                    int[] pixels = new int[data.length * 4];
                    buffer.getData().getPixels(0, 0, (int)((RectangularShape)bounds).getWidth(), (int)((RectangularShape)bounds).getHeight(), pixels);
                    int j = 0;
                    while ((double)j < ((RectangularShape)bounds).getHeight()) {
                        int i = 0;
                        while ((double)i < ((RectangularShape)bounds).getWidth()) {
                            data[j * (int)((RectangularShape)bounds).getWidth() + i] = pixels[j * 4 * (int)((RectangularShape)bounds).getWidth() + i * 4] > 0;
                            ++i;
                        }
                        ++j;
                    }
                    this.chars.put(Character.valueOf(c), new MapChar(data, (int)((RectangularShape)bounds).getWidth(), (int)((RectangularShape)bounds).getHeight(), (int)((RectangularShape)bounds).getY()));
                }
            }
        }
        return this.chars.get(Character.valueOf(c));
    }

    class MapChar {
        private boolean[] data;
        private int width;
        private int height;
        private int base;

        private MapChar(boolean[] data, int w, int h, int b) {
            this.data = data;
            this.width = w;
            this.height = h;
            this.base = b;
        }

        public boolean[] getData() {
            return this.data;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getBase() {
            return this.base;
        }
    }
}

