/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.mccore.config.parse;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.mccore.config.parse.DataArray;
import studio.magemonkey.codex.mccore.config.parse.DataSection;

public class JSONParser {
    private static int i = 0;

    public static DataSection parseResource(Plugin plugin, String path) {
        try {
            int bytes;
            InputStream read = plugin.getClass().getResourceAsStream("/" + path);
            StringBuilder builder = new StringBuilder();
            byte[] data = new byte[1024];
            do {
                bytes = read.read(data);
                builder.append(new String(data, 0, bytes, "UTF-8"));
            } while (bytes == 1024);
            read.close();
            return JSONParser.parseText(builder.toString());
        }
        catch (Exception ex) {
            Bukkit.getLogger().info("Failed to parse resource (" + path + ") - " + ex.getMessage());
            return new DataSection();
        }
    }

    public static DataSection parseFile(String path) {
        return JSONParser.parseFile(new File(path));
    }

    public static DataSection parseFile(File file) {
        try {
            if (file.exists()) {
                FileInputStream read = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                read.read(data);
                read.close();
                return JSONParser.parseText(new String(data, "UTF-8"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new DataSection();
    }

    public static DataSection parseText(String text) {
        if (text == null) {
            return new DataSection();
        }
        i = 0;
        return JSONParser.parse(text);
    }

    private static DataSection parse(String text) {
        DataSection data = new DataSection();
        if (text.charAt(i) != '{') {
            return data;
        }
        if (text.charAt(i + 1) == '}') {
            i += 2;
            return data;
        }
        while (text.charAt(i) != '}') {
            Object value;
            int next = text.indexOf(58, ++i);
            String key = text.charAt(i) == '\"' ? text.substring(i + 1, next - 1) : text.substring(i, next);
            switch (text.charAt(next + 1)) {
                case '{': {
                    i = next + 1;
                    value = JSONParser.parse(text);
                    break;
                }
                case '[': {
                    i = next + 1;
                    value = JSONParser.parseArray(text);
                    break;
                }
                case '\"': {
                    int end = text.indexOf(34, next + 2);
                    value = text.substring(next + 2, end);
                    i = end + 1;
                    break;
                }
                default: {
                    int end = JSONParser.next(text, next + 1);
                    value = text.substring(next + 1, end);
                    i = end;
                }
            }
            data.set(key, value);
        }
        ++i;
        return data;
    }

    private static DataArray parseArray(String text) {
        DataArray array = new DataArray();
        if (text.charAt(i) != '[') {
            return array;
        }
        if (text.charAt(i) == ']') {
            i += 2;
            return array;
        }
        while (text.charAt(i) != ']') {
            Object value;
            switch (text.charAt(++i)) {
                case '{': {
                    value = JSONParser.parse(text);
                    break;
                }
                case '[': {
                    value = JSONParser.parseArray(text);
                    break;
                }
                case '\"': {
                    int end = text.indexOf(34, i + 1);
                    value = text.substring(i + 1, end);
                    i = end + 1;
                    break;
                }
                default: {
                    int end = JSONParser.next(text, i);
                    value = text.substring(i, end);
                    i = end;
                }
            }
            array.add(value);
        }
        ++i;
        return array;
    }

    private static int next(String text, int index) {
        while (true) {
            switch (text.charAt(index)) {
                case ',': {
                    return index;
                }
                case ']': 
                case '}': {
                    return index;
                }
            }
            ++index;
        }
    }

    public static void save(DataSection data, String path) {
        JSONParser.save(data, new File(path));
    }

    public static void save(DataSection data, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            JSONParser.save(data, write);
            write.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void save(DataSection data, BufferedWriter write) throws IOException {
        StringBuilder sb = new StringBuilder();
        JSONParser.dump(data, sb);
        write.write(sb.toString());
    }

    public static void dump(DataSection data, StringBuilder builder) {
        builder.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append(':');
            JSONParser.writeValue(builder, entry.getValue());
        }
        builder.append('}');
    }

    private static void writeValue(StringBuilder builder, Object value) {
        if (value instanceof DataSection) {
            JSONParser.dump((DataSection)value, builder);
        } else if (value instanceof DataArray) {
            builder.append('[');
            boolean first = true;
            DataArray array = (DataArray)value;
            for (int i = 0; i < array.size(); ++i) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                JSONParser.writeValue(builder, array.get(i));
            }
            builder.append(']');
        } else if (value.toString().contains(":")) {
            builder.append('\"');
            builder.append(value.toString());
            builder.append('\"');
        } else {
            builder.append(value.toString());
        }
    }
}

