/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.manager.api.task;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;

public abstract class ITask<P extends CodexPlugin<P>> {
    @NotNull
    protected final P plugin;
    protected final long interval;
    protected final boolean async;
    protected int id;

    public ITask(@NotNull P plugin, int interval, boolean async) {
        this(plugin, (long)interval * 20L, async);
    }

    public abstract void action();

    public void start() {
        if (this.interval <= 0L) {
            return;
        }
        if (this.async) {
            this.async();
        } else {
            this.sync();
        }
    }

    private void sync() {
        this.id = this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, this::action, 1L, this.interval).getTaskId();
    }

    private void async() {
        this.id = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(this.plugin, this::action, 1L, this.interval).getTaskId();
    }

    public void stop() {
        if (this.interval <= 0L) {
            return;
        }
        this.plugin.getServer().getScheduler().cancelTask(this.getId());
    }

    @Generated
    public ITask(@NotNull P plugin, long interval, boolean async) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
        this.interval = interval;
        this.async = async;
    }

    @Generated
    public int getId() {
        return this.id;
    }
}

