/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.legacy.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.FireworkEffect;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.legacy.item.DataBuilder;
import studio.magemonkey.codex.legacy.item.FireworkEffectBuilder;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.ItemUtils;
import studio.magemonkey.codex.util.SerializationBuilder;

@SerializableAs(value="Codex_FireworkMeta")
public class FireworkBuilder
extends DataBuilder {
    private List<FireworkEffect> effects = new ArrayList<FireworkEffect>(10);
    private int power;

    public FireworkBuilder(Map<String, Object> map) {
        DeserializationWorker w = DeserializationWorker.start(map);
        this.power = w.getInt("power", 0);
        this.effects = ItemUtils.simpleDeserializeEffects((Collection)map.get("effects"));
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("effects", this.effects).append("power", this.power).toString();
    }

    public FireworkBuilder power(int power) {
        this.power = power;
        return this;
    }

    public FireworkBuilder effect(FireworkEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public FireworkBuilder effect(FireworkEffect.Builder effect) {
        this.effects.add(effect.build());
        return this;
    }

    public FireworkBuilder effect(FireworkEffectBuilder effect) {
        this.effects.add(effect.getEffect());
        return this;
    }

    public FireworkBuilder effect(FireworkEffect ... effects) {
        Collections.addAll(this.effects, effects);
        return this;
    }

    public FireworkBuilder effect(FireworkEffect.Builder ... effects) {
        for (FireworkEffect.Builder effect : effects) {
            this.effects.add(effect.build());
        }
        return this;
    }

    public FireworkBuilder effect(FireworkEffectBuilder ... effects) {
        for (FireworkEffectBuilder effect : effects) {
            this.effects.add(effect.getEffect());
        }
        return this;
    }

    public FireworkBuilder effect(Collection<FireworkEffect> effects) {
        this.effects.addAll(effects);
        return this;
    }

    public FireworkBuilder remove(FireworkEffect effect) {
        this.effects.remove(effect);
        return this;
    }

    public FireworkBuilder remove(FireworkEffect.Builder effect) {
        this.effects.remove(effect.build());
        return this;
    }

    public FireworkBuilder remove(FireworkEffectBuilder effect) {
        this.effects.remove(effect.getEffect());
        return this;
    }

    public FireworkBuilder remove(int effect) {
        this.effects.remove(effect);
        return this;
    }

    public FireworkBuilder clear() {
        this.effects.clear();
        return this;
    }

    @Override
    public void apply(ItemMeta itemMeta) {
        if (!(itemMeta instanceof FireworkMeta)) {
            return;
        }
        FireworkMeta meta = (FireworkMeta)itemMeta;
        meta.setPower(this.power);
        meta.clearEffects();
        meta.addEffects(this.effects);
    }

    @Override
    public FireworkBuilder use(ItemMeta itemMeta) {
        if (!(itemMeta instanceof FireworkMeta)) {
            return null;
        }
        FireworkMeta meta = (FireworkMeta)itemMeta;
        this.power = meta.getPower();
        this.effects = new ArrayList<FireworkEffect>(meta.getEffects());
        return this;
    }

    @Override
    public String getType() {
        return "firework";
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        SerializationBuilder b = SerializationBuilder.start(3).append(super.serialize());
        b.append("power", (Object)this.power);
        b.append("effects", ItemUtils.simpleSerializeEffects(this.effects));
        return b.build();
    }

    public static FireworkBuilder start() {
        return new FireworkBuilder();
    }

    @Generated
    public FireworkBuilder() {
    }
}

