/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.nms.v1_18_2;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemShears;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.ItemTrident;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.entity.Boat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.Codex;
import studio.magemonkey.codex.compat.NMS;

public class NMSImpl
implements NMS {
    public String getVersion() {
        return "1.18.2";
    }

    @NotNull
    public Object getConnection(Player player) {
        return ((CraftPlayer)player).getHandle().b;
    }

    @NotNull
    public Channel getChannel(@NotNull Player player) {
        return ((PlayerConnection)this.getConnection((Player)player)).a().m;
    }

    public void sendPacket(@NotNull Player player, @NotNull Object packet) {
        Preconditions.checkArgument((boolean)(packet instanceof Packet), (Object)"Packet must be an instance of net.minecraft.server.Packet");
        ((PlayerConnection)this.getConnection(player)).a((Packet)packet);
    }

    public void openChestAnimation(@NotNull Block chest, boolean open) {
        WorldServer world = ((CraftWorld)chest.getWorld()).getHandle();
        BlockPosition position = new BlockPosition(chest.getX(), chest.getY(), chest.getZ());
        IBlockData blockData = world.a_(position);
        world.a(position, blockData.b(), 1, open ? 1 : 0);
    }

    public void sendAttackPacket(@NotNull Player player, int i) {
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation((Entity)((CraftPlayer)player).getHandle(), i);
        this.sendPacket(player, packet);
    }

    @NotNull
    public String fixColors(@NotNull String str) {
        str = str.replace("\n", "%n%");
        IChatBaseComponent baseComponent = CraftChatMessage.fromStringOrNull((String)str);
        String singleColor = CraftChatMessage.fromComponent((IChatBaseComponent)baseComponent);
        return singleColor.replace("%n%", "\n");
    }

    public double getDefaultDamage(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.GENERIC_ATTACK_DAMAGE);
    }

    public double getDefaultSpeed(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.GENERIC_ATTACK_SPEED);
    }

    public double getDefaultArmor(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.GENERIC_ARMOR);
    }

    public double getDefaultToughness(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.GENERIC_ARMOR_TOUGHNESS);
    }

    public boolean isWeapon(@NotNull ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Item item = nmsItem.c();
        return item instanceof ItemSword || item instanceof ItemAxe || item instanceof ItemTrident;
    }

    public boolean isArmor(@NotNull ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Item item = nmsItem.c();
        return item instanceof ItemArmor;
    }

    public boolean isTool(@NotNull ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Item item = nmsItem.c();
        return item instanceof ItemTool || item instanceof ItemShears;
    }

    public String toJson(@NotNull ItemStack item) {
        try {
            NBTTagCompound nbtCompound = new NBTTagCompound();
            net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.b(nbtCompound);
            String js = nbtCompound.toString();
            if (js.length() > Short.MAX_VALUE) {
                ItemStack item2 = new ItemStack(item.getType());
                return this.toJson(item2);
            }
            return js;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setKiller(@NotNull LivingEntity entity, @NotNull Player killer) {
        try {
            EntityLiving hit = ((CraftLivingEntity)entity).getHandle();
            hit.bc = ((CraftPlayer)killer).getHandle();
            Field damageTime = this.getField(hit.getClass(), "bd");
            damageTime.setAccessible(true);
            damageTime.set(hit, 100);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to set killer. Something went wrong", e);
        }
    }

    public void changeSkull(@NotNull Block block, @NotNull String hash) {
        try {
            if (!(block.getState() instanceof Skull)) {
                return;
            }
            try {
                Skull skull = (Skull)block.getState();
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)hash.substring(0, 16));
                PlayerTextures textures = profile.getTextures();
                if (hash.startsWith("http")) {
                    textures.setSkin(new URL(hash));
                } else {
                    String decoded;
                    try {
                        decoded = new String(Base64.getDecoder().decode(hash));
                    }
                    catch (IllegalArgumentException ignored) {
                        try {
                            decoded = new String(Base64.getMimeDecoder().decode(hash));
                        }
                        catch (IllegalArgumentException ignored2) {
                            decoded = new String(Base64.getUrlDecoder().decode(hash));
                        }
                    }
                    JsonObject json = (JsonObject)new Gson().fromJson(decoded, JsonObject.class);
                    JsonObject texturesJson = json.getAsJsonObject("textures");
                    JsonObject skin = texturesJson.getAsJsonObject("SKIN");
                    String url = skin.get("url").getAsString();
                    textures.setSkin(new URL(url));
                }
                profile = (PlayerProfile)profile.update().get();
                skull.setOwnerProfile(profile);
                skull.update();
            }
            catch (Exception | NoSuchMethodError e) {
                Codex.info((String)"Could not change skull with modern method, trying legacy method.");
                if (!(block.getState() instanceof Skull)) {
                    return;
                }
                TileEntitySkull skull = (TileEntitySkull)((CraftWorld)block.getWorld()).getHandle().c_(new BlockPosition(block.getX(), block.getY(), block.getZ()));
                if (skull == null) {
                    return;
                }
                GameProfile profile = this.getNonPlayerProfile(hash);
                skull.a(profile);
                skull.e();
            }
        }
        catch (Exception e) {
            Codex.warn((String)"Could not update skull");
            e.printStackTrace();
        }
    }

    public void addSkullTexture(@NotNull ItemStack item, @NotNull String value, @NotNull UUID uuid) {
        if (item.getType() != Material.PLAYER_HEAD) {
            return;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta == null) {
            return;
        }
        try {
            PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)uuid, (String)uuid.toString().substring(0, 16));
            String decoded = new String(Base64.getDecoder().decode(value));
            JsonObject json = (JsonObject)new Gson().fromJson(decoded, JsonObject.class);
            JsonObject texturesJson = json.getAsJsonObject("textures");
            JsonObject skin = texturesJson.getAsJsonObject("SKIN");
            String url = skin.get("url").getAsString();
            playerProfile.getTextures().setSkin(new URL(url));
            meta.setOwnerProfile(playerProfile);
            item.setItemMeta((ItemMeta)meta);
        }
        catch (IllegalArgumentException | NoClassDefFoundError | NoSuchMethodError | MalformedURLException e) {
            super.addSkullTexture(item, value, uuid);
        }
    }

    public Object getNMSCopy(@NotNull ItemStack item) {
        return CraftItemStack.asNMSCopy((ItemStack)item);
    }

    public Material getMaterial(Boat boat) {
        TreeSpecies woodType = boat.getWoodType();
        return switch (woodType) {
            case TreeSpecies.REDWOOD -> Material.SPRUCE_BOAT;
            case TreeSpecies.BIRCH -> Material.BIRCH_BOAT;
            case TreeSpecies.JUNGLE -> Material.JUNGLE_BOAT;
            case TreeSpecies.ACACIA -> Material.ACACIA_BOAT;
            case TreeSpecies.DARK_OAK -> Material.DARK_OAK_BOAT;
            default -> Material.OAK_BOAT;
        };
    }

    public HoverEvent getHoverEvent(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        String itemString = meta != null ? meta.getAsString() : "{}";
        return new HoverEvent(HoverEvent.Action.SHOW_ITEM, new Content[]{new net.md_5.bungee.api.chat.hover.content.Item(itemStack.getType().getKey().getKey(), itemStack.getAmount(), ItemTag.ofNbt((String)itemString))});
    }
}

