/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.nms.v1_17;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemShears;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.ItemTrident;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.entity.Boat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.compat.NMS;

public class NMSImpl
implements NMS {
    public String getVersion() {
        return "1.17.1";
    }

    @NotNull
    public Object getConnection(Player player) {
        return ((CraftPlayer)player).getHandle().b;
    }

    @NotNull
    public Channel getChannel(@NotNull Player player) {
        return ((PlayerConnection)this.getConnection((Player)player)).a().k;
    }

    public void sendPacket(@NotNull Player player, @NotNull Object packet) {
        Preconditions.checkArgument((boolean)(packet instanceof Packet), (Object)"Packet must be an instance of net.minecraft.server.Packet");
        ((PlayerConnection)this.getConnection(player)).sendPacket((Packet)packet);
    }

    public void openChestAnimation(@NotNull Block chest, boolean open) {
        WorldServer world = ((CraftWorld)chest.getWorld()).getHandle();
        BlockPosition position = new BlockPosition(chest.getX(), chest.getY(), chest.getZ());
        IBlockData blockData = world.getType(position);
        world.playBlockAction(position, blockData.getBlock(), 1, open ? 1 : 0);
    }

    public void sendAttackPacket(@NotNull Player player, int i) {
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation((Entity)((CraftPlayer)player).getHandle(), i);
        this.sendPacket(player, packet);
    }

    @NotNull
    public String fixColors(@NotNull String str) {
        str = str.replace("\n", "%n%");
        IChatBaseComponent baseComponent = CraftChatMessage.fromStringOrNull((String)str);
        String singleColor = CraftChatMessage.fromComponent((IChatBaseComponent)baseComponent);
        return singleColor.replace("%n%", "\n");
    }

    public double getDefaultDamage(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.GENERIC_ATTACK_DAMAGE);
    }

    public double getDefaultSpeed(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.GENERIC_ATTACK_SPEED);
    }

    public double getDefaultArmor(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.GENERIC_ARMOR);
    }

    public double getDefaultToughness(@NotNull ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attribute.GENERIC_ARMOR_TOUGHNESS);
    }

    public boolean isWeapon(@NotNull ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Item item = nmsItem.getItem();
        return item instanceof ItemSword || item instanceof ItemAxe || item instanceof ItemTrident;
    }

    public boolean isArmor(@NotNull ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Item item = nmsItem.getItem();
        return item instanceof ItemArmor;
    }

    public boolean isTool(@NotNull ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Item item = nmsItem.getItem();
        return item instanceof ItemTool || item instanceof ItemShears;
    }

    public String toJson(@NotNull ItemStack item) {
        try {
            NBTTagCompound nbtCompound = new NBTTagCompound();
            net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.save(nbtCompound);
            String js = nbtCompound.toString();
            if (js.length() > Short.MAX_VALUE) {
                ItemStack item2 = new ItemStack(item.getType());
                return this.toJson(item2);
            }
            return js;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setKiller(@NotNull LivingEntity entity, @NotNull Player killer) {
        try {
            EntityLiving hit = ((CraftLivingEntity)entity).getHandle();
            hit.bc = ((CraftPlayer)killer).getHandle();
            Field damageTime = this.getField(hit.getClass(), "bd");
            damageTime.setAccessible(true);
            damageTime.set(hit, 100);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to set killer. Something went wrong", e);
        }
    }

    public void changeSkull(@NotNull Block block, @NotNull String hash) {
        if (!(block.getState() instanceof Skull)) {
            return;
        }
        TileEntitySkull skull = (TileEntitySkull)((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (skull == null) {
            return;
        }
        GameProfile profile = this.getNonPlayerProfile(hash);
        skull.setGameProfile(profile);
        skull.update();
    }

    public Object getNMSCopy(@NotNull ItemStack item) {
        return CraftItemStack.asNMSCopy((ItemStack)item);
    }

    public Material getMaterial(Boat boat) {
        TreeSpecies woodType = boat.getWoodType();
        return switch (woodType) {
            case TreeSpecies.REDWOOD -> Material.SPRUCE_BOAT;
            case TreeSpecies.BIRCH -> Material.BIRCH_BOAT;
            case TreeSpecies.JUNGLE -> Material.JUNGLE_BOAT;
            case TreeSpecies.ACACIA -> Material.ACACIA_BOAT;
            case TreeSpecies.DARK_OAK -> Material.DARK_OAK_BOAT;
            default -> Material.OAK_BOAT;
        };
    }
}

