/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.bungee;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BungeeUtil {
    public static final String CHANNEL = "magemonkey:codex";
    private static final List<ByteArrayDataOutput> queued = new ArrayList<ByteArrayDataOutput>();
    private static boolean queueRunning = false;
    private static boolean bungee = false;
    private static String bungeeId = "server";
    private static JavaPlugin plugin;

    public static boolean sendMessage(String ... data) {
        return BungeeUtil.sendMessage(CHANNEL, data);
    }

    public static boolean sendMessage(String channel, String[] data) {
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        return BungeeUtil.sendMessage(channel, player, data);
    }

    public static boolean sendMessage(String channel, Player sender, String ... data) {
        return BungeeUtil.sendMessage(channel, null, sender, data);
    }

    private static boolean sendMessage(String channel, UUID id, Player sender, String ... data) {
        if (!BungeeUtil.isBungee()) {
            return false;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(id == null ? UUID.randomUUID().toString() : id.toString());
        out.writeUTF(BungeeUtil.getBungeeId());
        for (String dat : data) {
            out.writeUTF(dat);
        }
        if (sender == null) {
            sender = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        }
        if (sender == null) {
            queued.add(out);
            BungeeUtil.queue();
            return true;
        }
        sender.sendPluginMessage((Plugin)plugin, channel, out.toByteArray());
        return true;
    }

    private static void sendMessage(ByteArrayDataOutput out) {
        BungeeUtil.sendMessage(CHANNEL, out);
    }

    private static void sendMessage(String channel, ByteArrayDataOutput out) {
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (player == null) {
            return;
        }
        BungeeUtil.sendMessage(channel, player, out);
    }

    private static void sendMessage(String channel, Player sender, ByteArrayDataOutput out) {
        sender.sendPluginMessage((Plugin)plugin, channel, out.toByteArray());
    }

    public static void broadcastMessage(String message) {
        BungeeUtil.sendMessage("Broadcast", message);
    }

    public static void sendPlayerMessage(String target, String message) {
        BungeeUtil.sendMessage("PlayerMessage", target, message);
    }

    public static void sendResponse(UUID id, String responseType) {
        BungeeUtil.sendResponse(CHANNEL, id, responseType);
    }

    public static void sendResponse(String channel, UUID id, String responseType) {
        BungeeUtil.sendMessage(channel, id, null, responseType);
    }

    private static void sendFirstQueue() {
        if (queued.isEmpty()) {
            return;
        }
        ByteArrayDataOutput out = queued.get(0);
        if (out == null) {
            queued.remove(0);
            return;
        }
        BungeeUtil.sendMessage(out);
        queued.remove(out);
    }

    public static void queue() {
        if (queueRunning) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (Bukkit.getOnlinePlayers().isEmpty()) {
                    return;
                }
                while (!queued.isEmpty()) {
                    BungeeUtil.sendFirstQueue();
                }
                queueRunning = false;
                this.cancel();
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 20L, 20L);
    }

    @Generated
    public static boolean isBungee() {
        return bungee;
    }

    @Generated
    public static void setBungee(boolean bungee) {
        BungeeUtil.bungee = bungee;
    }

    @Generated
    public static String getBungeeId() {
        return bungeeId;
    }

    @Generated
    public static void setBungeeId(String bungeeId) {
        BungeeUtil.bungeeId = bungeeId;
    }

    @Generated
    public static JavaPlugin getPlugin() {
        return plugin;
    }

    @Generated
    public static void setPlugin(JavaPlugin plugin) {
        BungeeUtil.plugin = plugin;
    }
}

