/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.manager.api.menu;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.manager.api.menu.Menu;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.manager.api.menu.YAMLMenu;

public abstract class YAMLListMenu<T>
extends YAMLMenu<T> {
    public YAMLListMenu(Plugin plugin, String path) {
        super(plugin, path);
    }

    @Override
    public void reload() {
        super.reload();
        int max = this.rows * 9;
        this.slots.keySet().removeIf(integer -> integer >= max);
    }

    @Override
    public void setSlots(Menu menu, T parameter) {
        menu.slots.clear();
        Player player = menu.getPlayer();
        List<Slot> entries = this.getEntries(parameter);
        int max = this.rows * 9;
        int index = 0;
        for (Slot entry : entries) {
            String value;
            while ((value = (String)this.slots.get(index % max)) != null) {
                Slot slot = this.getSlot(value, parameter, player);
                if (slot != null) {
                    menu.setSlot(index, slot);
                }
                ++index;
            }
            if (entry == null) continue;
            menu.setSlot(index, entry);
            ++index;
        }
        ItemStack emptySlot = this.getItem("empty");
        int size = menu.slots.lastKey() / (this.getRows() * 9) + 1;
        for (int i = 0; i < size; ++i) {
            menu.slots.putIfAbsent(i, new Slot(emptySlot));
        }
    }

    public abstract List<Slot> getEntries(T var1);
}

