/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.eval.javaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import studio.magemonkey.codex.util.eval.javaluator.BracketPair;
import studio.magemonkey.codex.util.eval.javaluator.Constant;
import studio.magemonkey.codex.util.eval.javaluator.Function;
import studio.magemonkey.codex.util.eval.javaluator.Operator;
import studio.magemonkey.codex.util.eval.javaluator.Token;

public class Tokenizer {
    private Pattern pattern;
    private boolean trimTokens;
    protected final Map<String, Function> functions;
    protected final Map<String, List<Operator>> operators;
    protected final Map<String, Constant> constants;
    protected final String functionArgumentSeparator;
    protected final Map<String, BracketPair> functionBrackets;
    protected final Map<String, BracketPair> expressionBrackets;

    public Tokenizer(List<String> delimiters, Map<String, Function> functions, Map<String, List<Operator>> operators, Map<String, Constant> constants, String functionArgumentSeparator, Map<String, BracketPair> functionBrackets, Map<String, BracketPair> expressionBrackets) {
        this.pattern = Tokenizer.delimitersToRegexp(delimiters);
        this.trimTokens = true;
        this.functions = functions;
        this.operators = operators;
        this.constants = constants;
        this.functionArgumentSeparator = functionArgumentSeparator;
        this.functionBrackets = functionBrackets;
        this.expressionBrackets = expressionBrackets;
    }

    public boolean isTrimTokens() {
        return this.trimTokens;
    }

    public void setTrimTokens(boolean trimTokens) {
        this.trimTokens = trimTokens;
    }

    protected static Pattern delimitersToRegexp(List<String> delimiters) {
        Collections.sort(delimiters, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -o1.compareTo(o2);
            }
        });
        StringBuilder result = new StringBuilder();
        result.append('(');
        for (String delim : delimiters) {
            if (result.length() != 1) {
                result.append('|');
            }
            result.append("\\Q").append(delim).append("\\E");
        }
        result.append(')');
        return Pattern.compile(result.toString());
    }

    public Collection<Token> tokenize(String string) {
        ArrayList<Token> res = new ArrayList<Token>();
        String[] lines = string.split("\\r?\\n");
        Token previous = null;
        for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            Token token;
            String line = lines[lineNum];
            Matcher m = this.pattern.matcher(lines[lineNum]);
            int pos = 0;
            while (m.find()) {
                if (pos != m.start() && (token = this.toToken(previous, string.substring(pos, m.start()).trim())) != null) {
                    token.setLineInfo(line, lineNum, pos, m.start() - 1);
                    res.add(token);
                    previous = token;
                }
                if ((token = this.toToken(previous, m.group().trim())) != null) {
                    token.setLineInfo(line, lineNum, m.start(), m.end() - 1);
                    res.add(token);
                    previous = token;
                }
                pos = m.end();
            }
            if (pos == string.length() || (token = this.toToken(previous, string.substring(pos).trim())) == null) continue;
            token.setLineInfo(line, lineNum, pos, string.length());
            res.add(token);
            previous = token;
        }
        return res;
    }

    public Token toToken(Token previous, String strToken) {
        if ((strToken = strToken.trim()).isEmpty()) {
            return null;
        }
        if (strToken.equals(this.functionArgumentSeparator)) {
            return Token.buildArgumentSeparator(strToken);
        }
        if (this.functions.containsKey(strToken)) {
            return Token.buildFunction(this.functions.get(strToken));
        }
        if (this.operators.containsKey(strToken)) {
            List<Operator> list = this.operators.get(strToken);
            return list.size() == 1 ? Token.buildOperator(list.get(0)) : Token.buildOperator(this.guessOperator(previous, list));
        }
        BracketPair brackets = this.getBracketPair(strToken);
        if (brackets != null) {
            if (brackets.getOpen().equals(strToken)) {
                return Token.buildOpenToken(brackets);
            }
            return Token.buildCloseToken(brackets);
        }
        return Token.buildLiteral(strToken);
    }

    protected BracketPair getBracketPair(String token) {
        BracketPair result = this.expressionBrackets.get(token);
        return result == null ? this.functionBrackets.get(token) : result;
    }

    protected Operator guessOperator(Token previous, List<Operator> candidates) {
        int argCount = previous != null && (previous.isCloseBracket() || previous.isLiteral()) ? 2 : 1;
        for (Operator operator : candidates) {
            if (operator.getOperandCount() != argCount) continue;
            return operator;
        }
        return null;
    }
}

