/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.util.StringUT;

public class ClickText {
    private final String text;
    private final Map<String, ClickWord> replacers;
    private ComponentBuilder builder;

    public ClickText(@NotNull String text) {
        this.text = StringUT.color(text);
        this.builder = new ComponentBuilder("");
        this.replacers = new HashMap<String, ClickWord>();
    }

    @NotNull
    public ClickWord createFullPlaceholder() {
        ClickWord clickWord = new ClickWord(this.text);
        this.replacers.put("*", clickWord);
        return clickWord;
    }

    @NotNull
    public ClickWord createPlaceholder(@NotNull String placeholder, @NotNull String text) {
        ClickWord clickWord = new ClickWord(text);
        this.replacers.put(placeholder, clickWord);
        return clickWord;
    }

    @NotNull
    private BaseComponent[] build(@NotNull String line) {
        this.builder = new ComponentBuilder("");
        ClickWord full = this.replacers.get("*");
        if (full != null) {
            this.builder.append((BaseComponent)full.build());
            return this.builder.create();
        }
        AbstractList pieces = new LinkedList<String>(Arrays.asList(line));
        for (String s : this.replacers.keySet()) {
            LinkedList<String> tmp = new LinkedList<String>();
            for (String piece : pieces) {
                if (!piece.contains(s)) {
                    tmp.add(piece);
                    continue;
                }
                String[] split = piece.split(s);
                for (int i = 0; i < split.length; ++i) {
                    tmp.add(split[i]);
                    if (!piece.endsWith(s) && i >= split.length - 1) continue;
                    tmp.add(s);
                }
            }
            pieces = new ArrayList(tmp);
        }
        for (String word : pieces) {
            ClickWord clickWord;
            Optional<String> optWord = this.replacers.keySet().stream().filter(holder -> word.contains((CharSequence)holder)).findFirst();
            ClickWord clickWord2 = clickWord = optWord.isPresent() ? this.replacers.get(optWord.get()) : null;
            if (clickWord != null) {
                this.builder.append((BaseComponent)clickWord.build(), ComponentBuilder.FormatRetention.NONE);
                continue;
            }
            this.builder.append(TextComponent.fromLegacyText((String)word), ComponentBuilder.FormatRetention.NONE);
        }
        return this.builder.create();
    }

    public void send(@NotNull CommandSender sender) {
        if (sender instanceof Player) {
            for (String line : this.text.split("\n")) {
                ((Player)sender).spigot().sendMessage(this.build(line));
            }
        }
    }

    public void send(@NotNull Set<Player> list) {
        for (String line : this.text.split("\n")) {
            BaseComponent[] jsonText = this.build(line);
            for (Player p : list) {
                p.spigot().sendMessage(jsonText);
            }
        }
    }

    public static class ClickWord {
        private final String text;
        public HoverEvent hover;
        public ClickEvent click;

        public ClickWord(@NotNull String text) {
            this.text = StringUT.color(text);
        }

        @NotNull
        public String getText() {
            return this.text;
        }

        @NotNull
        public HoverEvent getHoverEvent() {
            return this.hover;
        }

        @NotNull
        public ClickEvent getClickEvent() {
            return this.click;
        }

        @NotNull
        public ClickWord hint(@NotNull String text) {
            return this.hint(text.split("\n"));
        }

        @NotNull
        public ClickWord hint(@NotNull List<String> text) {
            return this.hint(text.toArray(new String[text.size()]));
        }

        @NotNull
        public ClickWord hint(String ... text) {
            StringBuilder textBuilder = new StringBuilder();
            for (String line : text) {
                if (textBuilder.length() > 0) {
                    textBuilder.append("\n");
                }
                textBuilder.append(line);
            }
            BaseComponent[] base = TextComponent.fromLegacyText((String)StringUT.color(textBuilder.toString()));
            this.hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(base)});
            return this;
        }

        @NotNull
        public ClickWord showItem(@NotNull ItemStack item) {
            this.hover = VersionManager.getNms().getHoverEvent(item);
            return this;
        }

        @Deprecated
        public void showEntity(@NotNull String json) {
            this.hover = new HoverEvent(HoverEvent.Action.SHOW_ENTITY, this.toBase(json));
        }

        @Deprecated
        public void achievement(@NotNull String id) {
            this.hover = new HoverEvent(HoverEvent.Action.SHOW_ACHIEVEMENT, this.toBase(StringUT.colorOff(id)));
        }

        @NotNull
        public ClickWord execCmd(@NotNull String cmd) {
            this.click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd);
            return this;
        }

        @NotNull
        public ClickWord suggCmd(@NotNull String cmd) {
            this.click = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, cmd);
            return this;
        }

        @NotNull
        public ClickWord url(@NotNull String url) {
            this.click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
            return this;
        }

        @NotNull
        public ClickWord file(@NotNull String path) {
            this.click = new ClickEvent(ClickEvent.Action.OPEN_FILE, path);
            return this;
        }

        @Deprecated
        public void page(int page) {
            this.click = new ClickEvent(ClickEvent.Action.CHANGE_PAGE, String.valueOf(page));
        }

        @NotNull
        public TextComponent build() {
            TextComponent component = new TextComponent(TextComponent.fromLegacyText((String)this.text));
            if (this.hover != null) {
                component.setHoverEvent(this.hover);
            }
            if (this.click != null) {
                component.setClickEvent(this.click);
            }
            return component;
        }

        @Deprecated
        @NotNull
        private BaseComponent[] toBase(@NotNull String text) {
            return new BaseComponent[]{new TextComponent(text)};
        }
    }
}

