/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.api;

import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.api.Replacer;

public enum CommandType {
    PLAYER{

        @Override
        public void invoke(CommandSender user, String command, Replacer ... r) {
            if (user instanceof Player) {
                ((Player)user).chat("/" + CommandType.replace(command, user, r));
            } else {
                Bukkit.dispatchCommand((CommandSender)user, (String)CommandType.replace(command, user, r));
            }
        }
    }
    ,
    OP{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(CommandSender user, String command, Replacer ... r) {
            boolean isOp = user.isOp();
            try {
                if (!isOp) {
                    user.setOp(true);
                }
                if (user instanceof Player) {
                    ((Player)user).chat("/" + CommandType.replace(command, user, r));
                } else {
                    Bukkit.dispatchCommand((CommandSender)user, (String)CommandType.replace(command, user, r));
                }
                if (!isOp) {
                    user.setOp(false);
                }
            }
            finally {
                if (!isOp) {
                    user.setOp(false);
                }
            }
        }
    }
    ,
    CONSOLE{

        @Override
        public void invoke(CommandSender user, String command, Replacer ... r) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)CommandType.replace(command, user, r));
        }
    };


    public abstract void invoke(CommandSender var1, String var2, Replacer ... var3);

    private static String replace(String command, CommandSender user, Replacer ... replacements) {
        String[] keys = new String[replacements.length + 1];
        String[] values = new String[replacements.length + 1];
        int i = 0;
        values[i] = user.getName();
        keys[i++] = "{player}";
        for (Replacer replacer : replacements) {
            values[i] = replacer.getTo();
            keys[i++] = replacer.getFrom();
        }
        return StringUtils.replaceEach((String)command, (String[])keys, (String[])values);
    }
}

