/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.Validate;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.util.FileUT;

public final class ResourceExtractor {
    private final JavaPlugin plugin;
    private final File extractFolder;
    private final String folderPath;
    private final String regex;

    public ResourceExtractor(JavaPlugin plugin, File extractFolder, String folderPath, String regex) {
        Validate.notNull((Object)plugin, (String)"The plugin cannot be null!", (Object[])new Object[0]);
        Validate.notNull((Object)plugin, (String)"The extract folder cannot be null!", (Object[])new Object[0]);
        Validate.notNull((Object)plugin, (String)"The folder path cannot be null!", (Object[])new Object[0]);
        this.extractFolder = extractFolder;
        this.folderPath = folderPath;
        this.plugin = plugin;
        this.regex = regex;
    }

    public void extract() throws IOException {
        this.extract(false, true);
    }

    public void extract(boolean override) throws IOException {
        this.extract(override, true);
    }

    public void extract(boolean override, boolean subPaths) throws IOException {
        File jarfile = null;
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            jarfile = (File)method.invoke((Object)this.plugin, new Object[0]);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (!this.extractFolder.exists()) {
            this.extractFolder.mkdirs();
        }
        JarFile jar = new JarFile(jarfile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            File file;
            JarEntry entry = entries.nextElement();
            String path = entry.getName();
            if (!path.startsWith(this.folderPath)) continue;
            if (entry.isDirectory()) {
                if (!subPaths || (file = new File(this.extractFolder, entry.getName().replaceFirst(this.folderPath, ""))).exists()) continue;
                file.mkdirs();
                continue;
            }
            file = subPaths ? new File(this.extractFolder, path.replaceFirst(this.folderPath, "")) : new File(this.extractFolder, path.substring(path.indexOf(File.separatorChar)));
            String name = file.getName();
            if (this.regex != null && !name.matches(this.regex)) continue;
            if (file.exists() && override) {
                file.delete();
            }
            if (file.exists()) continue;
            FileUT.create(file);
            InputStream is = jar.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(file);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
        jar.close();
    }
}

